/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsContext context;
    protected byte[] randomData;
    protected boolean useExplicitIV;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsContext tlsContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n) throws IOException {
        ParametersWithIV parametersWithIV;
        ParametersWithIV parametersWithIV2;
        byte[] byArray;
        byte[] byArray2;
        this.context = tlsContext;
        this.randomData = new byte[256];
        tlsContext.getSecureRandom().nextBytes(this.randomData);
        this.useExplicitIV = ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(tlsContext.getServerVersion().getEquivalentTLSVersion());
        int n2 = 2 * n + digest.getDigestSize() + digest2.getDigestSize();
        if (!this.useExplicitIV) {
            n2 += blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        }
        byte[] byArray3 = TlsUtils.calculateKeyBlock(tlsContext, n2);
        int n3 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray3, n3, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray3, n3 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray3, n3 += digest2.getDigestSize(), n);
        KeyParameter keyParameter2 = new KeyParameter(byArray3, n3 += n, n);
        n3 += n;
        if (this.useExplicitIV) {
            byArray2 = new byte[blockCipher.getBlockSize()];
            byArray = new byte[blockCipher2.getBlockSize()];
        } else {
            byArray2 = Arrays.copyOfRange(byArray3, n3, n3 + blockCipher.getBlockSize());
            byArray = Arrays.copyOfRange(byArray3, n3 += blockCipher.getBlockSize(), n3 + blockCipher2.getBlockSize());
            n3 += blockCipher2.getBlockSize();
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = blockCipher2;
            this.decryptCipher = blockCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter2, byArray);
            parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = blockCipher;
            this.decryptCipher = blockCipher2;
            parametersWithIV2 = new ParametersWithIV(keyParameter, byArray2);
            parametersWithIV = new ParametersWithIV(keyParameter2, byArray);
        }
        this.encryptCipher.init(true, parametersWithIV2);
        this.decryptCipher.init(false, parametersWithIV);
    }

    public int getPlaintextLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = n - n % n2 - n3 - 1;
        if (this.useExplicitIV) {
            n4 -= n2;
        }
        return n4;
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2;
        int n4;
        int n5 = this.encryptCipher.getBlockSize();
        int n6 = this.writeMac.getSize();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        int n7 = n5 - 1 - (n2 + n6) % n5;
        if (!protocolVersion.isDTLS() && !protocolVersion.isSSL()) {
            n4 = (255 - n7) / n5;
            int n8 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n4);
            n7 += n8 * n5;
        }
        n4 = n2 + n6 + n7 + 1;
        if (this.useExplicitIV) {
            n4 += n5;
        }
        byte[] byArray3 = new byte[n4];
        int n9 = 0;
        if (this.useExplicitIV) {
            byArray2 = new byte[n5];
            this.context.getSecureRandom().nextBytes(byArray2);
            this.encryptCipher.init(true, new ParametersWithIV(null, byArray2));
            System.arraycopy(byArray2, 0, byArray3, n9, n5);
            n9 += n5;
        }
        byArray2 = this.writeMac.calculateMac(l, s, byArray, n, n2);
        System.arraycopy(byArray, n, byArray3, n9, n2);
        System.arraycopy(byArray2, 0, byArray3, n9 + n2, byArray2.length);
        int n10 = n9 + n2 + byArray2.length;
        for (n3 = 0; n3 <= n7; ++n3) {
            byArray3[n3 + n10] = (byte)n7;
        }
        for (n3 = n9; n3 < n4; n3 += n5) {
            this.encryptCipher.processBlock(byArray3, n3, byArray3, n3);
        }
        return byArray3;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        boolean bl;
        int n3;
        int n4 = this.decryptCipher.getBlockSize();
        int n5 = this.readMac.getSize();
        int n6 = Math.max(n4, n5 + 1);
        if (this.useExplicitIV) {
            n6 += n4;
        }
        if (n2 < n6) {
            throw new TlsFatalAlert(50);
        }
        if (n2 % n4 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(false, new ParametersWithIV(null, byArray, n, n4));
            n += n4;
            n2 -= n4;
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            this.decryptCipher.processBlock(byArray, n + n3, byArray, n + n3);
        }
        n3 = this.checkPaddingConstantTime(byArray, n, n2, n4, n5);
        int n7 = n2 - n3 - n5;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n + n7, n + n7 + n5);
        byte[] byArray3 = this.readMac.calculateMacConstantTime(l, s, byArray, n, n7, n2 - n5, this.randomData);
        boolean bl2 = bl = !Arrays.constantTimeAreEqual(byArray3, byArray2);
        if (bl || n3 == 0) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n, n + n7);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        byte by = byArray[n5 - 1];
        int n6 = by & 0xFF;
        int n7 = n6 + 1;
        int n8 = 0;
        int n9 = 0;
        if (this.context.getServerVersion().isSSL() && n7 > n3 || n4 + n7 > n2) {
            n7 = 0;
        } else {
            int n10 = n5 - n7;
            do {
                n9 = (byte)(n9 | byArray[n10++] ^ by);
            } while (n10 < n5);
            n8 = n7;
            if (n9 != 0) {
                n7 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n8 < 256) {
            n9 = (byte)(n9 | byArray2[n8++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n9);
        return n7;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n) {
        int n2 = secureRandom.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, n);
    }

    protected int lowestBitSet(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }
}

