/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import javax.inject.Inject;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.domain.internal.DelegatingMutableObjectInfoWithMetadata;

public class SwiftObjectImpl
extends PayloadEnclosingImpl
implements SwiftObject,
Comparable<SwiftObject> {
    private final DelegatingMutableObjectInfoWithMetadata info;
    private Multimap<String, String> allHeaders = LinkedHashMultimap.create();

    @Inject
    public SwiftObjectImpl(MutableObjectInfoWithMetadata info) {
        this.info = new DelegatingMutableObjectInfoWithMetadata(info);
    }

    @Override
    public MutableObjectInfoWithMetadata getInfo() {
        return this.info;
    }

    @Override
    public Multimap<String, String> getAllHeaders() {
        return this.allHeaders;
    }

    @Override
    public void setAllHeaders(Multimap<String, String> allHeaders) {
        this.allHeaders = Preconditions.checkNotNull(allHeaders, "allHeaders");
    }

    @Override
    public int compareTo(SwiftObject o) {
        if (this.getInfo().getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getInfo().getName().compareTo(o.getInfo().getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftObjectImpl other = (SwiftObjectImpl)obj;
        return !(this.info == null ? other.info != null : !this.info.equals(other.info));
    }

    public String toString() {
        return "[info=" + this.info + "]";
    }

    @Override
    public void setPayload(Payload data) {
        HttpUtils.copy(data.getContentMetadata(), this.info);
        data.setContentMetadata(this.info);
        super.setPayload(data);
    }
}

