/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5;

import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate5.ConfigurableJtaPlatform;
import org.springframework.orm.hibernate5.SpringSessionContext;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LocalSessionFactoryBuilder
extends Configuration {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private static final TypeFilter[] DEFAULT_ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private final TypeFilter CONVERTER_TYPE_FILTER = new AnnotationTypeFilter(Converter.class, false);
    private final ResourcePatternResolver resourcePatternResolver;
    private TypeFilter[] entityTypeFilters = DEFAULT_ENTITY_TYPE_FILTERS;

    public LocalSessionFactoryBuilder(DataSource dataSource) {
        this(dataSource, new PathMatchingResourcePatternResolver());
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ClassLoader classLoader) {
        this(dataSource, new PathMatchingResourcePatternResolver(classLoader));
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ResourceLoader resourceLoader) {
        super(new BootstrapServiceRegistryBuilder().applyClassLoader(resourceLoader.getClassLoader()).build());
        this.getProperties().put("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        if (dataSource != null) {
            this.getProperties().put("hibernate.connection.datasource", dataSource);
        }
        this.getProperties().put("hibernate.classLoaders", Collections.singleton(resourceLoader.getClassLoader()));
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    public LocalSessionFactoryBuilder setJtaTransactionManager(Object jtaTransactionManager) {
        Assert.notNull(jtaTransactionManager, "Transaction manager reference must not be null");
        if (jtaTransactionManager instanceof JtaTransactionManager) {
            boolean webspherePresent = ClassUtils.isPresent("com.ibm.wsspi.uow.UOWManager", this.getClass().getClassLoader());
            if (webspherePresent) {
                this.getProperties().put("hibernate.transaction.jta.platform", "org.hibernate.engine.transaction.jta.platform.internal.WebSphereExtendedJtaPlatform");
            } else {
                JtaTransactionManager jtaTm = (JtaTransactionManager)jtaTransactionManager;
                if (jtaTm.getTransactionManager() == null) {
                    throw new IllegalArgumentException("Can only apply JtaTransactionManager which has a TransactionManager reference set");
                }
                this.getProperties().put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform(jtaTm.getTransactionManager(), jtaTm.getUserTransaction(), jtaTm.getTransactionSynchronizationRegistry()));
            }
        } else if (jtaTransactionManager instanceof TransactionManager) {
            this.getProperties().put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform((TransactionManager)jtaTransactionManager, null, null));
        } else {
            throw new IllegalArgumentException("Unknown transaction manager type: " + jtaTransactionManager.getClass().getName());
        }
        return this;
    }

    public LocalSessionFactoryBuilder setEntityTypeFilters(TypeFilter ... entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
        return this;
    }

    public LocalSessionFactoryBuilder addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
        return this;
    }

    public LocalSessionFactoryBuilder addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
        return this;
    }

    public LocalSessionFactoryBuilder scanPackages(String ... packagesToScan) throws HibernateException {
        TreeSet<String> entityClassNames = new TreeSet<String>();
        TreeSet<String> converterClassNames = new TreeSet<String>();
        TreeSet<String> packageNames = new TreeSet<String>();
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (this.matchesEntityTypeFilter(reader, readerFactory)) {
                        entityClassNames.add(className);
                        continue;
                    }
                    if (this.CONVERTER_TYPE_FILTER.match(reader, readerFactory)) {
                        converterClassNames.add(className);
                        continue;
                    }
                    if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                    packageNames.add(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", ex);
        }
        try {
            ClassLoader cl = this.resourcePatternResolver.getClassLoader();
            for (String className : entityClassNames) {
                this.addAnnotatedClass(cl.loadClass(className));
            }
            for (String className : converterClassNames) {
                this.addAttributeConverter(cl.loadClass(className));
            }
            for (String packageName : packageNames) {
                this.addPackage(packageName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", ex);
        }
        return this;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            for (TypeFilter filter : this.entityTypeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }
}

