/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.audit.AuditLogUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.mill.audit.generator.LastModifiedDateFileComparator;
import org.duracloud.mill.audit.generator.LogKey;
import org.duracloud.mill.auditor.AuditLogItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceLog {
    private static final Comparator<File> LAST_MODIFIED_DATE_COMPARATOR = new LastModifiedDateFileComparator();
    private static Logger log = LoggerFactory.getLogger(SpaceLog.class);
    private static SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat(DateUtil.DateFormat.LONG_FORMAT.getPattern());
    public static final long MAX_FILE_SIZE = 0xA00000L;
    private LogKey key;
    private File logDir;
    private Writer writer;
    private File currentLogFile;

    public SpaceLog(LogKey key, File logsRootDir) {
        this.key = key;
        this.logDir = this.createSpaceLogsDirectory(logsRootDir);
    }

    private File createSpaceLogsDirectory(File rootDir) {
        File directory = new File(rootDir.getAbsolutePath() + File.separator + this.key.getAccountId() + File.separator + this.key.getStoreId() + File.separator + this.key.getSpaceId());
        return directory;
    }

    public void close() {
        this.currentLogFile = null;
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void write(AuditLogItem item) throws IOException {
        this.makeDirIfNotExists();
        if (this.writer == null) {
            this.currentLogFile = this.getAvailableLogFile();
            this.writer = this.createWriter(this.currentLogFile);
            if (!this.currentLogFile.exists() || this.currentLogFile.length() == 0L) {
                this.writer.write(this.getHeader() + '\n');
            }
        }
        this.writer.write(this.formatRecord(item));
        this.writer.flush();
        if (this.currentLogFile.length() > 0xA00000L) {
            this.close();
        }
    }

    private String getHeader() {
        return AuditLogUtil.getHeader();
    }

    private File getAvailableLogFile() {
        File[] files = this.logDir.listFiles();
        if (files != null && files.length > 0) {
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList, LAST_MODIFIED_DATE_COMPARATOR);
            File lastModified = fileList.get(0);
            if (lastModified.length() < 0xA00000L) {
                return lastModified;
            }
        }
        return this.createNewLogFile();
    }

    private String formatRecord(AuditLogItem item) {
        return StringUtils.join((Object[])new String[]{item.getAccount(), item.getStoreId(), item.getSpaceId(), item.getContentId(), item.getContentMd5(), item.getContentSize(), item.getMimetype(), this.removeLineBreaksAndTabs(this.emptyStringIfNull(item.getContentProperties())), this.removeLineBreaksAndTabs(this.emptyStringIfNull(item.getSpaceAcls())), this.emptyStringIfNull(item.getSourceSpaceId()), this.emptyStringIfNull(item.getSourceContentId()), this.formatDate(new Date(item.getTimestamp())), item.getAction(), item.getUsername()}, "\t") + "\n";
    }

    private String removeLineBreaksAndTabs(String str) {
        return str.replaceAll("[\n\r\t]", "");
    }

    private String emptyStringIfNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    protected File createNewLogFile() {
        SimpleDateFormat format = new SimpleDateFormat(DateUtil.DateFormat.PLAIN_FORMAT.getPattern());
        String date = format.format(new Date());
        File file = new File(this.logDir, this.key.getAccountId() + "_" + this.key.getStoreId() + "_" + this.key.getSpaceId() + "-" + date + ".tsv");
        return file;
    }

    private Writer createWriter(File file) throws IOException {
        return new FileWriter(file, true);
    }

    private void makeDirIfNotExists() {
        if (!this.logDir.exists()) {
            this.logDir.mkdirs();
        }
    }

    protected String formatDate(Date timestamp) {
        return LOG_DATE_FORMAT.format(timestamp);
    }
}

