/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.StreamingDistributionList;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStreamingTaskRunner
implements TaskRunner {
    private final Logger log = LoggerFactory.getLogger(BaseStreamingTaskRunner.class);
    public static final String STREAMING_HOST_PROP = "streaming-host";
    public static final String STREAMING_TYPE_PROP = "streaming-type";
    public static final String S3_ORIGIN_SUFFIX = ".s3.amazonaws.com";
    public static final String S3_ORIGIN_OAI_PREFIX = "origin-access-identity/cloudfront/";
    protected static final int maxRetries = 8;
    protected StorageProvider s3Provider;
    protected S3StorageProvider unwrappedS3Provider;
    protected AmazonS3Client s3Client;
    protected AmazonCloudFrontClient cfClient;
    protected String cfAccountId;
    protected String cfKeyId;
    protected String cfKeyPath;

    @Override
    public abstract String getName();

    @Override
    public abstract String performTask(String var1);

    protected StreamingDistributionSummary getExistingDistribution(String bucketName) {
        List<StreamingDistributionSummary> dists = this.getAllExistingDistributions(bucketName);
        if (dists.isEmpty()) {
            return null;
        }
        return dists.get(0);
    }

    private boolean isDistFromBucket(String bucketName, StreamingDistributionSummary distSummary) {
        String bucketOrigin = bucketName + S3_ORIGIN_SUFFIX;
        return bucketOrigin.equals(distSummary.getS3Origin().getDomainName());
    }

    protected List<StreamingDistributionSummary> getAllExistingDistributions(String bucketName) {
        ArrayList<StreamingDistributionSummary> distListForBucket = new ArrayList<StreamingDistributionSummary>();
        StreamingDistributionList distList = this.cfClient.listStreamingDistributions(new ListStreamingDistributionsRequest()).getStreamingDistributionList();
        for (StreamingDistributionSummary distSummary : distList.getItems()) {
            if (!this.isDistFromBucket(bucketName, distSummary)) continue;
            distListForBucket.add(distSummary);
        }
        return distListForBucket;
    }

    protected void setDistributionState(String distId, boolean enabled) {
        GetStreamingDistributionConfigResult result = this.cfClient.getStreamingDistributionConfig(new GetStreamingDistributionConfigRequest(distId));
        StreamingDistributionConfig distConfig = result.getStreamingDistributionConfig();
        distConfig.setEnabled(enabled);
        this.cfClient.updateStreamingDistribution(new UpdateStreamingDistributionRequest().withStreamingDistributionConfig(distConfig).withIfMatch(result.getETag()).withId(distId));
    }

    protected Iterator<String> getSpaceContents(String spaceId) {
        for (int i = 0; i < 8; ++i) {
            try {
                return this.s3Provider.getSpaceContents(spaceId, null);
            }
            catch (Exception e) {
                this.log.warn("Exception encountered attempting to get contents for streaming space: " + spaceId + ", error message: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new DuraCloudRuntimeException("Exceeded retries attempting to get space contents for " + spaceId);
    }

    protected void removeStreamingHostFromSpaceProps(String spaceId) {
        Map<String, String> spaceProps = this.s3Provider.getSpaceProperties(spaceId);
        if (spaceProps.containsKey(STREAMING_HOST_PROP)) {
            spaceProps.remove(STREAMING_HOST_PROP);
            spaceProps.remove(STREAMING_TYPE_PROP);
            this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
        }
    }

    protected void wait(int index) {
        try {
            Thread.sleep(1000 * index);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void checkThatStreamingServiceIsEnabled(StorageProvider s3Provider, String spaceId, String taskName) {
        Map<String, String> spaceProperties = s3Provider.getSpaceProperties(spaceId);
        if (!spaceProperties.containsKey(STREAMING_TYPE_PROP)) {
            throw new UnsupportedTaskException(taskName, "The " + taskName + " task can only be used after a space has been configured to enable streaming. Use " + "enable-streaming" + " to enable streaming on this space.");
        }
    }

    public static enum STREAMING_TYPE {
        OPEN,
        SECURE;

    }
}

