/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class BlobMetadataImpl
extends StorageMetadataImpl
implements BlobMetadata {
    private final URI publicUri;
    private final String container;
    private final ContentMetadata contentMetadata;

    public BlobMetadataImpl(String id, String name, @Nullable Location location, URI uri, String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata, @Nullable URI publicUri, @Nullable String container, ContentMetadata contentMetadata) {
        super(StorageType.BLOB, id, name, location, uri, eTag, creationDate, lastModified, userMetadata);
        this.publicUri = publicUri;
        this.container = container;
        this.contentMetadata = Preconditions.checkNotNull(contentMetadata, "contentMetadata");
    }

    @Override
    public URI getPublicUri() {
        return this.publicUri;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }
}

