/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.type.NullType;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.functions.OnlyElementOrNull;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import org.jclouds.http.functions.ParseXMLWithJAXB;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnInputStream;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.GetAcceptHeaders;

public class TransformerForRequest
implements Function<HttpRequest, Function<HttpResponse, ?>> {
    private final ParseSax.Factory parserFactory;
    private final Injector injector;
    private final GetAcceptHeaders getAcceptHeaders;
    private static final TypeToken<ListenableFuture<Boolean>> futureBooleanToken = new TypeToken<ListenableFuture<Boolean>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final TypeToken<ListenableFuture<String>> futureStringToken = new TypeToken<ListenableFuture<String>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final TypeToken<ListenableFuture<Void>> futureVoidToken = new TypeToken<ListenableFuture<Void>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final TypeToken<ListenableFuture<URI>> futureURIToken = new TypeToken<ListenableFuture<URI>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final TypeToken<ListenableFuture<InputStream>> futureInputStreamToken = new TypeToken<ListenableFuture<InputStream>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final TypeToken<ListenableFuture<HttpResponse>> futureHttpResponseToken = new TypeToken<ListenableFuture<HttpResponse>>(){
        private static final long serialVersionUID = 1L;
    };

    @Inject
    TransformerForRequest(Injector injector, ParseSax.Factory parserFactory, GetAcceptHeaders getAcceptHeaders) {
        this.injector = injector;
        this.parserFactory = parserFactory;
        this.getAcceptHeaders = getAcceptHeaders;
    }

    @Override
    public Function<HttpResponse, ?> apply(HttpRequest in) {
        GeneratedHttpRequest request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(in);
        Class<? extends ParseSax.HandlerWithResult<?>> handler = TransformerForRequest.getSaxResponseParserClassOrNull(request.getInvocation().getInvokable());
        Function<HttpResponse, Object> transformer = handler != null ? this.parserFactory.create(this.injector.getInstance(handler)) : this.getTransformerForMethod(request.getInvocation(), this.injector);
        if (transformer instanceof InvocationContext) {
            ((InvocationContext)InvocationContext.class.cast(transformer)).setContext(request);
        }
        if (request.getInvocation().getInvokable().isAnnotationPresent(Transform.class)) {
            Function<?, ?> wrappingTransformer = this.injector.getInstance(request.getInvocation().getInvokable().getAnnotation(Transform.class).value());
            if (wrappingTransformer instanceof InvocationContext) {
                ((InvocationContext)((Object)wrappingTransformer)).setContext(request);
            }
            transformer = Functions.compose((Function)Function.class.cast(wrappingTransformer), transformer);
        }
        return transformer;
    }

    @VisibleForTesting
    protected Key<? extends Function<HttpResponse, ?>> getParserOrThrowException(Invocation invocation) {
        Invokable<?, ?> invoked = invocation.getInvokable();
        Set<String> acceptHeaders = this.getAcceptHeaders.apply(invocation);
        ResponseParser annotation = invoked.getAnnotation(ResponseParser.class);
        Class<?> rawReturnType = invoked.getReturnType().getRawType();
        if (annotation == null) {
            if (rawReturnType.equals(Void.TYPE) || invoked.getReturnType().equals(futureVoidToken)) {
                return Key.get(ReleasePayloadAndReturn.class);
            }
            if (rawReturnType.equals(Boolean.TYPE) || rawReturnType.equals(Boolean.class) || invoked.getReturnType().equals(futureBooleanToken)) {
                return Key.get(ReturnTrueIf2xx.class);
            }
            if (rawReturnType.equals(InputStream.class) || invoked.getReturnType().equals(futureInputStreamToken)) {
                return Key.get(ReturnInputStream.class);
            }
            if (rawReturnType.equals(HttpResponse.class) || invoked.getReturnType().equals(futureHttpResponseToken)) {
                return Key.get((Class)Class.class.cast(IdentityFunction.class));
            }
            if (acceptHeaders.contains("application/json")) {
                return TransformerForRequest.getJsonParserKeyForMethod(invoked);
            }
            if (acceptHeaders.contains("application/xml") || invoked.isAnnotationPresent(JAXBResponseParser.class)) {
                return TransformerForRequest.getJAXBParserKeyForMethod(invoked);
            }
            if (rawReturnType.equals(String.class) || invoked.getReturnType().equals(futureStringToken)) {
                return Key.get(ReturnStringIf2xx.class);
            }
            if (rawReturnType.equals(URI.class) || invoked.getReturnType().equals(futureURIToken)) {
                return Key.get(ParseURIFromListOrLocationHeaderIf20x.class);
            }
            throw new IllegalStateException("You must specify a ResponseParser annotation on: " + invoked.toString());
        }
        return Key.get(annotation.value());
    }

    private static Key<? extends Function<HttpResponse, ?>> getJAXBParserKeyForMethod(Invokable<?, ?> invoked) {
        Optional<Type> configuredReturnVal = Optional.absent();
        if (invoked.isAnnotationPresent(JAXBResponseParser.class)) {
            Class<?> configuredClass = invoked.getAnnotation(JAXBResponseParser.class).value();
            configuredReturnVal = configuredClass.equals(NullType.class) ? Optional.absent() : Optional.of(configuredClass);
        }
        Type returnVal = configuredReturnVal.or(TransformerForRequest.getReturnTypeFor(invoked.getReturnType()));
        ParameterizedType parserType = Types.newParameterizedType(ParseXMLWithJAXB.class, new Type[]{returnVal});
        return Key.get(parserType);
    }

    private static Key<? extends Function<HttpResponse, ?>> getJsonParserKeyForMethod(Invokable<?, ?> invoked) {
        ParameterizedType parserType = invoked.isAnnotationPresent(Unwrap.class) ? Types.newParameterizedType(UnwrapOnlyJsonValue.class, new Type[]{TransformerForRequest.getReturnTypeFor(invoked.getReturnType())}) : Types.newParameterizedType(ParseJson.class, new Type[]{TransformerForRequest.getReturnTypeFor(invoked.getReturnType())});
        return Key.get(parserType);
    }

    static Type getReturnTypeFor(TypeToken<?> typeToken) {
        ParameterizedType futureType;
        Type returnVal = typeToken.getType();
        if (typeToken.getRawType().getTypeParameters().length == 0) {
            returnVal = typeToken.getRawType();
        } else if (typeToken.getRawType().equals(ListenableFuture.class) && (returnVal = (futureType = (ParameterizedType)typeToken.getType()).getActualTypeArguments()[0]) instanceof WildcardType) {
            returnVal = ((WildcardType)WildcardType.class.cast(returnVal)).getUpperBounds()[0];
        }
        return returnVal;
    }

    @VisibleForTesting
    public Function<HttpResponse, ?> getTransformerForMethod(Invocation invocation, Injector injector) {
        Function<HttpResponse, Object> transformer;
        Invokable<?, ?> invoked = invocation.getInvokable();
        if (invoked.isAnnotationPresent(SelectJson.class)) {
            Type returnVal = TransformerForRequest.getReturnTypeFor(invoked.getReturnType());
            if (invoked.isAnnotationPresent(OnlyElement.class)) {
                returnVal = Types.newParameterizedType(Set.class, new Type[]{returnVal});
            }
            transformer = new ParseFirstJsonValueNamed(injector.getInstance(GsonWrapper.class), TypeLiteral.get(returnVal), invoked.getAnnotation(SelectJson.class).value());
            if (invoked.isAnnotationPresent(OnlyElement.class)) {
                transformer = Functions.compose(new OnlyElementOrNull(), transformer);
            }
        } else {
            transformer = injector.getInstance(this.getParserOrThrowException(invocation));
        }
        return transformer;
    }

    static Class<? extends ParseSax.HandlerWithResult<?>> getSaxResponseParserClassOrNull(Invokable<?, ?> invoked) {
        XMLResponseParser annotation = invoked.getAnnotation(XMLResponseParser.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }
}

