/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface RoleAdminAsyncApi {
    @Named(value="role:list")
    @GET
    @Path(value="OS-KSADM/roles")
    @SelectJson(value={"roles"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Role>> list();

    @Named(value="role:create")
    @POST
    @Path(value="OS-KSADM/roles")
    @SelectJson(value={"role"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @WrapWith(value="role")
    public ListenableFuture<? extends Role> create(@PayloadParam(value="name") String var1);

    @Named(value="role:get")
    @GET
    @SelectJson(value={"role"})
    @Consumes(value={"application/json"})
    @Path(value="OS-KSADM/roles/{roleId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Role> get(@PathParam(value="roleId") String var1);

    @Named(value="role:delete")
    @DELETE
    @Path(value="OS-KSADM/roles/{id}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);
}

