/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudfront.AmazonCloudFrontAsync;
import com.amazonaws.services.cloudfront.AmazonCloudFrontAsyncClientBuilder;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionResult;
import com.amazonaws.services.cloudfront.model.CreateDistributionWithTagsRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionWithTagsResult;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.CreateInvalidationResult;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionWithTagsResult;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteDistributionResult;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionResult;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.services.cloudfront.model.GetInvalidationResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsResult;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsResult;
import com.amazonaws.services.cloudfront.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudfront.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudfront.model.TagResourceRequest;
import com.amazonaws.services.cloudfront.model.TagResourceResult;
import com.amazonaws.services.cloudfront.model.UntagResourceRequest;
import com.amazonaws.services.cloudfront.model.UntagResourceResult;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateDistributionResult;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudFrontAsyncClient
extends AmazonCloudFrontClient
implements AmazonCloudFrontAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudFrontAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCloudFrontAsyncClientBuilder asyncBuilder() {
        return AmazonCloudFrontAsyncClientBuilder.standard();
    }

    AmazonCloudFrontAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(CreateCloudFrontOriginAccessIdentityRequest request) {
        return this.createCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(CreateCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResult> asyncHandler) {
        final CreateCloudFrontOriginAccessIdentityRequest finalRequest = (CreateCloudFrontOriginAccessIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public CreateCloudFrontOriginAccessIdentityResult call() throws Exception {
                CreateCloudFrontOriginAccessIdentityResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateCloudFrontOriginAccessIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(CreateDistributionRequest request) {
        return this.createDistributionAsync(request, null);
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(CreateDistributionRequest request, final AsyncHandler<CreateDistributionRequest, CreateDistributionResult> asyncHandler) {
        final CreateDistributionRequest finalRequest = (CreateDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDistributionResult>(){

            @Override
            public CreateDistributionResult call() throws Exception {
                CreateDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDistributionWithTagsResult> createDistributionWithTagsAsync(CreateDistributionWithTagsRequest request) {
        return this.createDistributionWithTagsAsync(request, null);
    }

    @Override
    public Future<CreateDistributionWithTagsResult> createDistributionWithTagsAsync(CreateDistributionWithTagsRequest request, final AsyncHandler<CreateDistributionWithTagsRequest, CreateDistributionWithTagsResult> asyncHandler) {
        final CreateDistributionWithTagsRequest finalRequest = (CreateDistributionWithTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDistributionWithTagsResult>(){

            @Override
            public CreateDistributionWithTagsResult call() throws Exception {
                CreateDistributionWithTagsResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateDistributionWithTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(CreateInvalidationRequest request) {
        return this.createInvalidationAsync(request, null);
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(CreateInvalidationRequest request, final AsyncHandler<CreateInvalidationRequest, CreateInvalidationResult> asyncHandler) {
        final CreateInvalidationRequest finalRequest = (CreateInvalidationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInvalidationResult>(){

            @Override
            public CreateInvalidationResult call() throws Exception {
                CreateInvalidationResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateInvalidation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(CreateStreamingDistributionRequest request) {
        return this.createStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(CreateStreamingDistributionRequest request, final AsyncHandler<CreateStreamingDistributionRequest, CreateStreamingDistributionResult> asyncHandler) {
        final CreateStreamingDistributionRequest finalRequest = (CreateStreamingDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamingDistributionResult>(){

            @Override
            public CreateStreamingDistributionResult call() throws Exception {
                CreateStreamingDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateStreamingDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamingDistributionWithTagsResult> createStreamingDistributionWithTagsAsync(CreateStreamingDistributionWithTagsRequest request) {
        return this.createStreamingDistributionWithTagsAsync(request, null);
    }

    @Override
    public Future<CreateStreamingDistributionWithTagsResult> createStreamingDistributionWithTagsAsync(CreateStreamingDistributionWithTagsRequest request, final AsyncHandler<CreateStreamingDistributionWithTagsRequest, CreateStreamingDistributionWithTagsResult> asyncHandler) {
        final CreateStreamingDistributionWithTagsRequest finalRequest = (CreateStreamingDistributionWithTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamingDistributionWithTagsResult>(){

            @Override
            public CreateStreamingDistributionWithTagsResult call() throws Exception {
                CreateStreamingDistributionWithTagsResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeCreateStreamingDistributionWithTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCloudFrontOriginAccessIdentityResult> deleteCloudFrontOriginAccessIdentityAsync(DeleteCloudFrontOriginAccessIdentityRequest request) {
        return this.deleteCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<DeleteCloudFrontOriginAccessIdentityResult> deleteCloudFrontOriginAccessIdentityAsync(DeleteCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResult> asyncHandler) {
        final DeleteCloudFrontOriginAccessIdentityRequest finalRequest = (DeleteCloudFrontOriginAccessIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCloudFrontOriginAccessIdentityResult>(){

            @Override
            public DeleteCloudFrontOriginAccessIdentityResult call() throws Exception {
                DeleteCloudFrontOriginAccessIdentityResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeDeleteCloudFrontOriginAccessIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDistributionResult> deleteDistributionAsync(DeleteDistributionRequest request) {
        return this.deleteDistributionAsync(request, null);
    }

    @Override
    public Future<DeleteDistributionResult> deleteDistributionAsync(DeleteDistributionRequest request, final AsyncHandler<DeleteDistributionRequest, DeleteDistributionResult> asyncHandler) {
        final DeleteDistributionRequest finalRequest = (DeleteDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDistributionResult>(){

            @Override
            public DeleteDistributionResult call() throws Exception {
                DeleteDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeDeleteDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamingDistributionResult> deleteStreamingDistributionAsync(DeleteStreamingDistributionRequest request) {
        return this.deleteStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<DeleteStreamingDistributionResult> deleteStreamingDistributionAsync(DeleteStreamingDistributionRequest request, final AsyncHandler<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResult> asyncHandler) {
        final DeleteStreamingDistributionRequest finalRequest = (DeleteStreamingDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStreamingDistributionResult>(){

            @Override
            public DeleteStreamingDistributionResult call() throws Exception {
                DeleteStreamingDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeDeleteStreamingDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(GetCloudFrontOriginAccessIdentityRequest request) {
        return this.getCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(GetCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResult> asyncHandler) {
        final GetCloudFrontOriginAccessIdentityRequest finalRequest = (GetCloudFrontOriginAccessIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetCloudFrontOriginAccessIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(GetCloudFrontOriginAccessIdentityConfigRequest request) {
        return this.getCloudFrontOriginAccessIdentityConfigAsync(request, null);
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(GetCloudFrontOriginAccessIdentityConfigRequest request, final AsyncHandler<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResult> asyncHandler) {
        final GetCloudFrontOriginAccessIdentityConfigRequest finalRequest = (GetCloudFrontOriginAccessIdentityConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityConfigResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityConfigResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityConfigResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetCloudFrontOriginAccessIdentityConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(GetDistributionRequest request) {
        return this.getDistributionAsync(request, null);
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(GetDistributionRequest request, final AsyncHandler<GetDistributionRequest, GetDistributionResult> asyncHandler) {
        final GetDistributionRequest finalRequest = (GetDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDistributionResult>(){

            @Override
            public GetDistributionResult call() throws Exception {
                GetDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(GetDistributionConfigRequest request) {
        return this.getDistributionConfigAsync(request, null);
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(GetDistributionConfigRequest request, final AsyncHandler<GetDistributionConfigRequest, GetDistributionConfigResult> asyncHandler) {
        final GetDistributionConfigRequest finalRequest = (GetDistributionConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDistributionConfigResult>(){

            @Override
            public GetDistributionConfigResult call() throws Exception {
                GetDistributionConfigResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetDistributionConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(GetInvalidationRequest request) {
        return this.getInvalidationAsync(request, null);
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(GetInvalidationRequest request, final AsyncHandler<GetInvalidationRequest, GetInvalidationResult> asyncHandler) {
        final GetInvalidationRequest finalRequest = (GetInvalidationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInvalidationResult>(){

            @Override
            public GetInvalidationResult call() throws Exception {
                GetInvalidationResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetInvalidation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(GetStreamingDistributionRequest request) {
        return this.getStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(GetStreamingDistributionRequest request, final AsyncHandler<GetStreamingDistributionRequest, GetStreamingDistributionResult> asyncHandler) {
        final GetStreamingDistributionRequest finalRequest = (GetStreamingDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStreamingDistributionResult>(){

            @Override
            public GetStreamingDistributionResult call() throws Exception {
                GetStreamingDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetStreamingDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(GetStreamingDistributionConfigRequest request) {
        return this.getStreamingDistributionConfigAsync(request, null);
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(GetStreamingDistributionConfigRequest request, final AsyncHandler<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResult> asyncHandler) {
        final GetStreamingDistributionConfigRequest finalRequest = (GetStreamingDistributionConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStreamingDistributionConfigResult>(){

            @Override
            public GetStreamingDistributionConfigResult call() throws Exception {
                GetStreamingDistributionConfigResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeGetStreamingDistributionConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(ListCloudFrontOriginAccessIdentitiesRequest request) {
        return this.listCloudFrontOriginAccessIdentitiesAsync(request, null);
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(ListCloudFrontOriginAccessIdentitiesRequest request, final AsyncHandler<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResult> asyncHandler) {
        final ListCloudFrontOriginAccessIdentitiesRequest finalRequest = (ListCloudFrontOriginAccessIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCloudFrontOriginAccessIdentitiesResult>(){

            @Override
            public ListCloudFrontOriginAccessIdentitiesResult call() throws Exception {
                ListCloudFrontOriginAccessIdentitiesResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListCloudFrontOriginAccessIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(ListDistributionsRequest request) {
        return this.listDistributionsAsync(request, null);
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(ListDistributionsRequest request, final AsyncHandler<ListDistributionsRequest, ListDistributionsResult> asyncHandler) {
        final ListDistributionsRequest finalRequest = (ListDistributionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDistributionsResult>(){

            @Override
            public ListDistributionsResult call() throws Exception {
                ListDistributionsResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListDistributions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributionsByWebACLIdResult> listDistributionsByWebACLIdAsync(ListDistributionsByWebACLIdRequest request) {
        return this.listDistributionsByWebACLIdAsync(request, null);
    }

    @Override
    public Future<ListDistributionsByWebACLIdResult> listDistributionsByWebACLIdAsync(ListDistributionsByWebACLIdRequest request, final AsyncHandler<ListDistributionsByWebACLIdRequest, ListDistributionsByWebACLIdResult> asyncHandler) {
        final ListDistributionsByWebACLIdRequest finalRequest = (ListDistributionsByWebACLIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDistributionsByWebACLIdResult>(){

            @Override
            public ListDistributionsByWebACLIdResult call() throws Exception {
                ListDistributionsByWebACLIdResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListDistributionsByWebACLId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(ListInvalidationsRequest request) {
        return this.listInvalidationsAsync(request, null);
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(ListInvalidationsRequest request, final AsyncHandler<ListInvalidationsRequest, ListInvalidationsResult> asyncHandler) {
        final ListInvalidationsRequest finalRequest = (ListInvalidationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInvalidationsResult>(){

            @Override
            public ListInvalidationsResult call() throws Exception {
                ListInvalidationsResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListInvalidations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(ListStreamingDistributionsRequest request) {
        return this.listStreamingDistributionsAsync(request, null);
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(ListStreamingDistributionsRequest request, final AsyncHandler<ListStreamingDistributionsRequest, ListStreamingDistributionsResult> asyncHandler) {
        final ListStreamingDistributionsRequest finalRequest = (ListStreamingDistributionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamingDistributionsResult>(){

            @Override
            public ListStreamingDistributionsResult call() throws Exception {
                ListStreamingDistributionsResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListStreamingDistributions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(UpdateCloudFrontOriginAccessIdentityRequest request) {
        return this.updateCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(UpdateCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResult> asyncHandler) {
        final UpdateCloudFrontOriginAccessIdentityRequest finalRequest = (UpdateCloudFrontOriginAccessIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public UpdateCloudFrontOriginAccessIdentityResult call() throws Exception {
                UpdateCloudFrontOriginAccessIdentityResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeUpdateCloudFrontOriginAccessIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(UpdateDistributionRequest request) {
        return this.updateDistributionAsync(request, null);
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(UpdateDistributionRequest request, final AsyncHandler<UpdateDistributionRequest, UpdateDistributionResult> asyncHandler) {
        final UpdateDistributionRequest finalRequest = (UpdateDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDistributionResult>(){

            @Override
            public UpdateDistributionResult call() throws Exception {
                UpdateDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeUpdateDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(UpdateStreamingDistributionRequest request) {
        return this.updateStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(UpdateStreamingDistributionRequest request, final AsyncHandler<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResult> asyncHandler) {
        final UpdateStreamingDistributionRequest finalRequest = (UpdateStreamingDistributionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStreamingDistributionResult>(){

            @Override
            public UpdateStreamingDistributionResult call() throws Exception {
                UpdateStreamingDistributionResult result = null;
                try {
                    result = AmazonCloudFrontAsyncClient.this.executeUpdateStreamingDistribution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

