/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import org.jclouds.concurrent.TransformParallelException;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

@Beta
public class FutureIterables {
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private static int maxRetries = 5;
    @Inject(optional=true)
    @Named(value="jclouds.retries-delay-start")
    private static long delayStart = 50L;
    @Inject(optional=true)
    private static BackoffLimitedRetryHandler retryHandler = BackoffLimitedRetryHandler.INSTANCE;

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, ListenableFuture<? extends T>> function, ListeningExecutorService exec, @Nullable Long maxTime, Logger logger2, String logPrefix) {
        return FutureIterables.transformParallel(fromIterable, function, exec, maxTime, logger2, logPrefix, retryHandler, maxRetries);
    }

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, ListenableFuture<? extends T>> function, ListeningExecutorService exec, @Nullable Long maxTime, Logger logger2, String logPrefix, BackoffLimitedRetryHandler retryHandler, int maxRetries) {
        Map exceptions = Maps.newHashMap();
        HashMap<F, ListenableFuture<? extends T>> responses = Maps.newHashMap();
        for (int i = 0; i < maxRetries; ++i) {
            for (F from : fromIterable) {
                ListenableFuture<? extends T> to = function.apply(from);
                responses.put(from, to);
            }
            try {
                exceptions = FutureIterables.awaitCompletion(responses, exec, maxTime, logger2, logPrefix);
            }
            catch (TimeoutException te) {
                throw Throwables.propagate(te);
            }
            if (exceptions.size() <= 0 || Iterables.any(exceptions.values(), Throwables2.containsThrowable(AuthorizationException.class))) break;
            fromIterable = exceptions.keySet();
            retryHandler.imposeBackoffExponentialDelay(delayStart, 2, i + 1, maxRetries, String.format("error %s: %s: %s", logPrefix, fromIterable, exceptions));
        }
        if (exceptions.size() > 0) {
            return (Iterable)Throwables2.propagateAuthorizationOrOriginalException(new TransformParallelException((Map)Map.class.cast(responses), exceptions, logPrefix));
        }
        return FutureIterables.unwrap(responses.values());
    }

    public static <F> Map<F, Exception> awaitCompletion(Map<F, ? extends ListenableFuture<?>> responses, ListeningExecutorService exec, @Nullable Long maxTime, final Logger logger2, final String logPrefix) throws TimeoutException {
        final ConcurrentMap errorMap = Maps.newConcurrentMap();
        if (responses.size() == 0) {
            return errorMap;
        }
        final int total = responses.size();
        final CountDownLatch doneSignal = new CountDownLatch(total);
        final AtomicInteger complete = new AtomicInteger(0);
        final AtomicInteger errors = new AtomicInteger(0);
        final long start = System.currentTimeMillis();
        for (final Map.Entry<F, ListenableFuture<?>> future : responses.entrySet()) {
            future.getValue().addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ((ListenableFuture)future.getValue()).get();
                        complete.incrementAndGet();
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                        FutureIterables.logException(logger2, logPrefix, total, complete.get(), errors.get(), start, e);
                        errorMap.put(future.getKey(), e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }

                public String toString() {
                    return "callGetOnFuture(" + future.getKey() + "," + future.getValue() + ")";
                }
            }, exec);
        }
        try {
            String message;
            if (maxTime != null) {
                if (!doneSignal.await(maxTime, TimeUnit.MILLISECONDS)) {
                    message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
                    TimeoutException te = new TimeoutException(message);
                    logger2.error(te, message, new Object[0]);
                    throw te;
                }
            } else {
                doneSignal.await();
            }
            if (errors.get() > 0) {
                message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
                RuntimeException exception = new RuntimeException(message);
                logger2.error(exception, message, new Object[0]);
            }
            if (logger2.isTraceEnabled()) {
                message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
                logger2.trace(message, new Object[0]);
            }
        }
        catch (InterruptedException ie) {
            String message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
            logger2.error(ie, message, new Object[0]);
            throw Throwables.propagate(ie);
        }
        return errorMap;
    }

    private static <T> Iterable<T> unwrap(Iterable<ListenableFuture<? extends T>> values) {
        return Iterables.transform(values, new Function<ListenableFuture<? extends T>, T>(){

            @Override
            public T apply(ListenableFuture<? extends T> from) {
                try {
                    return from.get();
                }
                catch (InterruptedException e) {
                    Throwables.propagate(e);
                }
                catch (ExecutionException e) {
                    Throwables.propagate(e);
                }
                return null;
            }

            public String toString() {
                return "callGetOnFuture()";
            }
        });
    }

    private static void logException(Logger logger2, String logPrefix, int total, int complete, int errors, long start, Exception e) {
        String message = FutureIterables.message(logPrefix, total, complete, errors, start);
        logger2.error(e, message, new Object[0]);
    }

    private static String message(String prefix, int size, int complete, int errors, long start) {
        return String.format("%s, completed: %d/%d, errors: %d, rate: %dms/op", prefix, complete, size, errors, (long)((double)(System.currentTimeMillis() - start) / (double)size));
    }
}

