/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.http.HttpUtils;

public final class SwiftFallbacks {
    private SwiftFallbacks() {
    }

    public static final class TrueOn404FalseOn409
    implements Fallback<Boolean> {
        @Override
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (HttpUtils.contains404(Preconditions.checkNotNull(t, "throwable"))) {
                return true;
            }
            if (HttpUtils.returnValueOnCodeOrNull(t, false, Predicates.equalTo(409)) != null) {
                return false;
            }
            throw Throwables.propagate(t);
        }
    }
}

