/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.suppliers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.functions.EndpointToSupplierURI;

@Singleton
public class LocationIdToURIFromAccessForTypeAndVersion
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Supplier<Access> access;
    protected final EndpointToSupplierURI endpointToSupplierURI;
    protected final Function<Endpoint, String> endpointToLocationId;
    protected final String apiType;
    protected final String apiVersion;
    private final Predicate<Endpoint> apiVersionEqualsVersionId = new Predicate<Endpoint>(){

        @Override
        public boolean apply(Endpoint input) {
            return input.getVersionId().equals(LocationIdToURIFromAccessForTypeAndVersion.this.apiVersion);
        }
    };
    private final Predicate<Endpoint> versionAware = new Predicate<Endpoint>(){

        @Override
        public boolean apply(Endpoint input) {
            return input.getVersionId() != null;
        }
    };
    private final Predicate<Service> apiTypeEquals = new Predicate<Service>(){

        @Override
        public boolean apply(Service input) {
            return input.getType().equals(LocationIdToURIFromAccessForTypeAndVersion.this.apiType);
        }
    };

    @Inject
    public LocationIdToURIFromAccessForTypeAndVersion(Supplier<Access> access, EndpointToSupplierURI endpointToSupplierURI, Function<Endpoint, String> endpointToLocationId, @Assisted(value="apiType") String apiType, @Nullable @Assisted(value="apiVersion") String apiVersion) {
        this.access = access;
        this.endpointToSupplierURI = endpointToSupplierURI;
        this.endpointToLocationId = endpointToLocationId;
        this.apiType = apiType;
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        Map<String, Endpoint> locationToEndpoint;
        FluentIterable<Service> services = FluentIterable.from(this.access.get()).filter(this.apiTypeEquals);
        if (services.toSet().size() == 0) {
            throw new NoSuchElementException(String.format("apiType %s not found in catalog %s", this.apiType, services));
        }
        Iterable endpoints = Iterables.concat(services);
        if (Iterables.size(endpoints) == 0) {
            throw new NoSuchElementException(String.format("no endpoints for apiType %s in services %s", this.apiType, services));
        }
        boolean checkVersionId = Iterables.any(endpoints, this.versionAware);
        ImmutableListMultimap<String, Endpoint> locationToEndpoints = Multimaps.index(endpoints, this.endpointToLocationId);
        if (checkVersionId && this.apiVersion != null) {
            locationToEndpoint = this.refineToVersionSpecificEndpoint(locationToEndpoints);
            if (locationToEndpoint.size() == 0) {
                throw new NoSuchElementException(String.format("no endpoints for apiType %s are of version %s, or version agnostic: %s", this.apiType, this.apiVersion, locationToEndpoints));
            }
        } else {
            locationToEndpoint = this.firstEndpointInLocation(locationToEndpoints);
        }
        this.logger.debug("endpoints for apiType %s and version %s: %s", this.apiType, this.apiVersion, locationToEndpoints);
        return Maps.transformValues(locationToEndpoint, this.endpointToSupplierURI);
    }

    @VisibleForTesting
    Map<String, Endpoint> firstEndpointInLocation(Multimap<String, Endpoint> locationToEndpoints) {
        ImmutableMap.Builder<String, Endpoint> locationToEndpointBuilder = ImmutableMap.builder();
        block3: for (Map.Entry<String, Collection<Endpoint>> entry : locationToEndpoints.asMap().entrySet()) {
            String locationId = entry.getKey();
            Collection<Endpoint> endpoints = entry.getValue();
            switch (endpoints.size()) {
                case 0: {
                    this.logNoEndpointsInLocation(locationId);
                    continue block3;
                }
            }
            locationToEndpointBuilder.put(locationId, Iterables.get(endpoints, 0));
        }
        return locationToEndpointBuilder.build();
    }

    @VisibleForTesting
    Map<String, Endpoint> refineToVersionSpecificEndpoint(Multimap<String, Endpoint> locationToEndpoints) {
        ImmutableMap.Builder locationToEndpointBuilder = ImmutableMap.builder();
        block3: for (Map.Entry<String, Collection<Endpoint>> entry : locationToEndpoints.asMap().entrySet()) {
            String locationId = entry.getKey();
            Collection<Endpoint> endpoints = entry.getValue();
            switch (endpoints.size()) {
                case 0: {
                    this.logNoEndpointsInLocation(locationId);
                    continue block3;
                }
            }
            LocationIdToURIFromAccessForTypeAndVersion.putIfPresent(locationId, this.strictMatchEndpointVersion(endpoints, locationId), locationToEndpointBuilder);
        }
        return locationToEndpointBuilder.build();
    }

    private Optional<Endpoint> strictMatchEndpointVersion(Iterable<Endpoint> endpoints, String locationId) {
        Optional<Endpoint> endpointOfVersion = Iterables.tryFind(endpoints, this.apiVersionEqualsVersionId);
        if (!endpointOfVersion.isPresent()) {
            this.logger.debug("no endpoints of apiType %s matched expected version %s in location %s: %s", this.apiType, this.apiVersion, locationId, endpoints);
        }
        return endpointOfVersion;
    }

    private void logNoEndpointsInLocation(String locationId) {
        this.logger.debug("no endpoints found for apiType %s in location %s", this.apiType, locationId);
    }

    private static <K, V> void putIfPresent(K key, Optional<V> value, ImmutableMap.Builder<K, V> builder) {
        if (value.isPresent()) {
            builder.put(key, value.get());
        }
    }

    public String toString() {
        return "locationIdToURIFromAccessForTypeAndVersion(" + this.apiType + ", " + this.apiVersion + ")";
    }

    public static interface Factory {
        public LocationIdToURIFromAccessForTypeAndVersion createForApiTypeAndVersion(@Assisted(value="apiType") String var1, @Nullable @Assisted(value="apiVersion") String var2) throws NoSuchElementException;
    }
}

