/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;

public class Service
extends ForwardingSet<Endpoint> {
    private final String id;
    private final String type;
    private final String name;
    private final String description;
    private final Set<Endpoint> endpoints;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromService(this);
    }

    @ConstructorProperties(value={"id", "type", "name", "description", "endpoints"})
    protected Service(@Nullable String id, String type, String name, @Nullable String description, @Nullable Set<Endpoint> endpoints) {
        this.id = id;
        this.type = Preconditions.checkNotNull(type, "type");
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.endpoints = endpoints == null ? ImmutableSet.of() : ImmutableSet.copyOf(endpoints);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id, this.type, this.name, this.description, this.endpoints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Service that = (Service)Service.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.type, that.type) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.endpoints, that.endpoints);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("id", this.id).add("type", this.type).add("name", this.name).add("description", this.description).add("endpoints", this.endpoints);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    protected Set<Endpoint> delegate() {
        return this.endpoints;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String type;
        protected String name;
        protected String description;
        protected ImmutableSet.Builder<Endpoint> endpoints = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T endpoint(Endpoint endpoint) {
            this.endpoints.add((Object)endpoint);
            return this.self();
        }

        public T endpoints(Iterable<Endpoint> endpoints) {
            this.endpoints.addAll((Iterable)endpoints);
            return this.self();
        }

        public Service build() {
            return new Service(this.id, this.type, this.name, this.description, (Set<Endpoint>)((Object)this.endpoints.build()));
        }

        public T fromService(Service in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).type(in.getType())).name(in.getName())).description(in.getDescription())).endpoints(in);
        }
    }
}

