/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import com.amazonaws.services.s3.AmazonS3Client;
import java.util.HashMap;
import org.duracloud.mill.audit.generator.SystemConfig;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.swiftstorage.SwiftStorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuditGeneratorConfig {
    private static Logger log = LoggerFactory.getLogger(AuditGeneratorConfig.class);

    @Bean
    public String logsDirectory() {
        String dir = this.systemConfig().getLogsDirectory();
        log.info("initializing logsDirectory with value: {}", (Object)dir);
        return dir;
    }

    private SystemConfig systemConfig() {
        return SystemConfig.instance();
    }

    @Bean
    public String auditLogSpaceId() {
        return SystemConfig.getInstance().getAuditLogSpaceId();
    }

    @Bean
    public StorageProvider storageProvider() {
        SystemConfig systemConfig = this.systemConfig();
        if (systemConfig.getSwiftEndpoint() != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(StorageAccount.OPTS.SWIFT_S3_ENDPOINT.name(), systemConfig.getSwiftEndpoint());
            map.put(StorageAccount.OPTS.SWIFT_S3_SIGNER_TYPE.name(), systemConfig.getSwiftSignerType());
            return new SwiftStorageProvider(systemConfig.getSwiftAccessKey(), systemConfig.getSwiftSecretKey(), map);
        }
        return new S3StorageProvider(new AmazonS3Client(), "aduracloudmillprefix", null);
    }
}

