/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.ContentIdUtil;
import org.duracloud.mill.audit.generator.LogKey;
import org.duracloud.mill.audit.generator.LogManager;
import org.duracloud.mill.audit.generator.SpaceLog;
import org.duracloud.mill.audit.generator.SpaceLogUploadException;
import org.duracloud.mill.db.model.JpaAuditLogItem;
import org.duracloud.mill.db.repo.JpaAuditLogItemRepo;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LogManagerImpl
implements LogManager {
    private static Logger log = LoggerFactory.getLogger(LogManagerImpl.class);
    private JpaAuditLogItemRepo repo;
    private Map<LogKey, SpaceLog> logMap = new HashMap<LogKey, SpaceLog>();
    private File logsDirectory;
    private StorageProvider storageProvider;
    private String auditLogSpaceId;
    private int ageInDaysOfPurgeableWrittenLogEntries = 30;
    private List<JpaAuditLogItem> recentWrites = new LinkedList<JpaAuditLogItem>();

    @Autowired
    public LogManagerImpl(StorageProvider storageProvider, String logsDirectory, JpaAuditLogItemRepo repo, @Qualifier(value="auditLogSpaceId") String auditLogSpaceId) {
        this.storageProvider = storageProvider;
        this.logsDirectory = new File(logsDirectory);
        this.repo = repo;
        this.auditLogSpaceId = auditLogSpaceId;
        if (!this.logsDirectory.exists()) {
            throw new RuntimeException("logsDirectory (" + logsDirectory + ") does not exist.");
        }
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager")
    public void write(JpaAuditLogItem item) {
        SpaceLog auditLog = this.getLog(item);
        try {
            if (!this.isEqualToRecentlyWritten(item)) {
                auditLog.write(item);
                this.recentWrites.add(0, item);
                if (this.recentWrites.size() > 10) {
                    this.recentWrites.remove(this.recentWrites.size() - 1);
                }
            } else {
                log.info("We detected log item that matches another item that just written, differing only in timestamp: {}. This item will not be written....", (Object)item);
            }
            JpaAuditLogItem fresh = (JpaAuditLogItem)this.repo.getOne(item.getId());
            fresh.setWritten(true);
            this.repo.saveAndFlush(fresh);
        }
        catch (IOException ex) {
            log.error("failed to write to file. Database was not updated: " + ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private SpaceLog getLog(JpaAuditLogItem item) {
        LogKey key = new LogKey(item.getAccount(), item.getStoreId(), item.getSpaceId());
        SpaceLog auditLog = this.logMap.get(key);
        if (auditLog == null) {
            auditLog = this.createSpaceLog(key);
            this.logMap.put(key, auditLog);
        }
        return auditLog;
    }

    protected SpaceLog createSpaceLog(LogKey key) {
        return new SpaceLog(key, this.logsDirectory);
    }

    private void uploadLogs() {
        log.info("closing audit logs...");
        for (Map.Entry<LogKey, SpaceLog> entry : this.logMap.entrySet()) {
            entry.getValue().close();
            log.debug("closed audit log {}", (Object)entry.getKey());
        }
        this.logMap.clear();
        log.info("audit logs closed.");
        try {
            for (final File file : this.getLogFiles(this.logsDirectory)) {
                new Retrier(3).execute(new Retriable(){

                    @Override
                    public Object retry() throws SpaceLogUploadException {
                        String string;
                        log.info("Uploading log file {}", (Object)file.getAbsolutePath());
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
                            String md5 = checksumUtil.generateChecksum(file);
                            String contentId = ContentIdUtil.getContentId(file, LogManagerImpl.this.logsDirectory, null);
                            LogManagerImpl.this.storageProvider.addContent(LogManagerImpl.this.auditLogSpaceId, contentId, "text/tsv", null, file.length(), md5, fis);
                            fis.close();
                            log.info("successfully uploaded log {}  to durastore.", (Object)file.getAbsoluteFile());
                            if (LogManagerImpl.this.fileIsFull(file)) {
                                file.delete();
                                log.info("log file {} deleted from local storage.", (Object)file.getAbsolutePath());
                            }
                            string = "success";
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception ex) {
                                throw new SpaceLogUploadException("failed to upload " + file.getAbsolutePath() + " to " + LogManagerImpl.this.storageProvider + ":" + ex.getMessage(), ex);
                            }
                        }
                        fis.close();
                        return string;
                    }
                });
            }
            log.info("All logs successfully uploaded.");
        }
        catch (Exception ex) {
            log.error("Upload failed: not all files uploaded successfully:  " + ex.getMessage(), ex);
        }
    }

    private boolean fileIsFull(File file) {
        return file.length() >= 0xA00000L;
    }

    protected Collection<File> getLogFiles(File directory) {
        return FileUtils.listFiles(directory, FileFilterUtils.trueFileFilter(), FileFilterUtils.trueFileFilter());
    }

    @Override
    public void flushLogs() {
        this.uploadLogs();
    }

    @Override
    @Transactional(value="millJpaRepoTransactionManager")
    public void purgeExpired() {
        log.info("flushing all written log entries over {} days old.", (Object)this.ageInDaysOfPurgeableWrittenLogEntries);
        Calendar c = Calendar.getInstance();
        c.add(5, this.ageInDaysOfPurgeableWrittenLogEntries * -1);
        Date date = c.getTime();
        long deleted = this.repo.deleteByWrittenTrueAndTimestampLessThan(date.getTime());
        log.info("successfully deleted {} audit log entries that had been written and were timestamped before {}", (Object)deleted, (Object)date);
    }

    private boolean isEqualToRecentlyWritten(JpaAuditLogItem current) {
        for (JpaAuditLogItem old : this.recentWrites) {
            if (!this.equals(old.getAccount(), current.getAccount()) || !this.equals(old.getAction(), current.getAction()) || !this.equals(old.getContentId(), current.getContentId()) || !this.equals(old.getContentMd5(), current.getContentMd5()) || !this.equals(old.getContentProperties(), current.getContentProperties()) || !this.equals(old.getContentSize(), current.getContentSize()) || !this.equals(old.getStoreId(), current.getStoreId()) || !this.equals(old.getSpaceId(), current.getSpaceId()) || !this.equals(old.getSpaceAcls(), current.getSpaceAcls()) || !this.equals(old.getMimetype(), current.getMimetype()) || !this.equals(old.getSourceContentId(), current.getSourceContentId()) || !this.equals(old.getSourceSpaceId(), current.getSourceSpaceId()) || !this.equals(old.getUsername(), current.getUsername())) continue;
            return true;
        }
        return false;
    }

    private boolean equals(String string1, String string2) {
        return StringUtils.equals(string1, string2);
    }
}

