/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.common.storageprovider;

import org.duracloud.audit.provider.AuditStorageProvider;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.util.SimpleUserUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.snapshotstorage.ChronopolisStorageProvider;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.swiftstorage.SwiftStorageProvider;

public class StorageProviderFactory {
    public StorageProvider createWithAudit(StorageProviderCredentials credentials, String accountSubdomain, TaskQueue auditQueue) {
        SimpleUserUtil userUtil = new SimpleUserUtil();
        StorageProvider storageprovider = this.create(credentials);
        AuditStorageProvider auditProvider = new AuditStorageProvider(storageprovider, accountSubdomain, credentials.getProviderId(), credentials.getProviderType().getName(), userUtil, auditQueue);
        return auditProvider;
    }

    public StorageProvider create(StorageProviderCredentials credentials) {
        StorageProviderType storageProviderType = credentials.getProviderType();
        if (storageProviderType.equals((Object)StorageProviderType.AMAZON_S3)) {
            return new S3StorageProvider(credentials.getAccessKey(), credentials.getSecretKey(), credentials.getOptions());
        }
        if (storageProviderType.equals((Object)StorageProviderType.AMAZON_GLACIER)) {
            return new GlacierStorageProvider(credentials.getAccessKey(), credentials.getSecretKey(), credentials.getOptions());
        }
        if (storageProviderType.equals((Object)StorageProviderType.CHRONOPOLIS)) {
            return new ChronopolisStorageProvider(credentials.getAccessKey(), credentials.getSecretKey(), credentials.getOptions());
        }
        if (storageProviderType.equals((Object)StorageProviderType.SWIFT_S3)) {
            return new SwiftStorageProvider(credentials.getAccessKey(), credentials.getSecretKey(), credentials.getOptions());
        }
        throw new RuntimeException(storageProviderType + " is not a supported storage provider type");
    }
}

