/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListRealtimeLogConfigsRequestMarshaller
implements Marshaller<Request<ListRealtimeLogConfigsRequest>, ListRealtimeLogConfigsRequest> {
    @Override
    public Request<ListRealtimeLogConfigsRequest> marshall(ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest) {
        if (listRealtimeLogConfigsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRealtimeLogConfigsRequest> request = new DefaultRequest<ListRealtimeLogConfigsRequest>(listRealtimeLogConfigsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/realtime-log-config";
        request.setResourcePath(uriResourcePath);
        if (listRealtimeLogConfigsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listRealtimeLogConfigsRequest.getMaxItems()));
        }
        if (listRealtimeLogConfigsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listRealtimeLogConfigsRequest.getMarker()));
        }
        return request;
    }
}

