/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyCookiesConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyHeadersConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig;
import com.amazonaws.services.cloudfront.model.QueryStringNames;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateOriginRequestPolicyRequestMarshaller
implements Marshaller<Request<CreateOriginRequestPolicyRequest>, CreateOriginRequestPolicyRequest> {
    @Override
    public Request<CreateOriginRequestPolicyRequest> marshall(CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) {
        if (createOriginRequestPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateOriginRequestPolicyRequest> request = new DefaultRequest<CreateOriginRequestPolicyRequest>(createOriginRequestPolicyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/origin-request-policy";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            OriginRequestPolicyConfig originRequestPolicyConfig = createOriginRequestPolicyRequest.getOriginRequestPolicyConfig();
            if (originRequestPolicyConfig != null) {
                OriginRequestPolicyQueryStringsConfig queryStringsConfig;
                OriginRequestPolicyCookiesConfig cookiesConfig;
                OriginRequestPolicyHeadersConfig headersConfig;
                xmlWriter.startElement("OriginRequestPolicyConfig");
                if (originRequestPolicyConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(originRequestPolicyConfig.getComment()).endElement();
                }
                if (originRequestPolicyConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(originRequestPolicyConfig.getName()).endElement();
                }
                if ((headersConfig = originRequestPolicyConfig.getHeadersConfig()) != null) {
                    Headers headers;
                    xmlWriter.startElement("HeadersConfig");
                    if (headersConfig.getHeaderBehavior() != null) {
                        xmlWriter.startElement("HeaderBehavior").value(headersConfig.getHeaderBehavior()).endElement();
                    }
                    if ((headers = headersConfig.getHeaders()) != null) {
                        SdkInternalList headersItemsList;
                        xmlWriter.startElement("Headers");
                        if (headers.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(headers.getQuantity()).endElement();
                        }
                        if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String headersItemsListValue : headersItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(headersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cookiesConfig = originRequestPolicyConfig.getCookiesConfig()) != null) {
                    CookieNames cookies;
                    xmlWriter.startElement("CookiesConfig");
                    if (cookiesConfig.getCookieBehavior() != null) {
                        xmlWriter.startElement("CookieBehavior").value(cookiesConfig.getCookieBehavior()).endElement();
                    }
                    if ((cookies = cookiesConfig.getCookies()) != null) {
                        SdkInternalList cookieNamesItemsList;
                        xmlWriter.startElement("Cookies");
                        if (cookies.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(cookies.getQuantity()).endElement();
                        }
                        if (!(cookieNamesItemsList = (SdkInternalList)cookies.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(cookieNamesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((queryStringsConfig = originRequestPolicyConfig.getQueryStringsConfig()) != null) {
                    QueryStringNames queryStrings;
                    xmlWriter.startElement("QueryStringsConfig");
                    if (queryStringsConfig.getQueryStringBehavior() != null) {
                        xmlWriter.startElement("QueryStringBehavior").value(queryStringsConfig.getQueryStringBehavior()).endElement();
                    }
                    if ((queryStrings = queryStringsConfig.getQueryStrings()) != null) {
                        SdkInternalList queryStringNamesItemsList;
                        xmlWriter.startElement("QueryStrings");
                        if (queryStrings.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(queryStrings.getQuantity()).endElement();
                        }
                        if (!(queryStringNamesItemsList = (SdkInternalList)queryStrings.getItems()).isEmpty() || !queryStringNamesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String queryStringNamesItemsListValue : queryStringNamesItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(queryStringNamesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

