/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.duracloud.mill.audit.generator.AuditLogGenerator;
import org.duracloud.mill.audit.generator.SystemConfig;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.DriverSupport;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class AuditLogGeneratorDriver
extends DriverSupport {
    private static final Logger log = LoggerFactory.getLogger(AuditLogGeneratorDriver.class);

    public AuditLogGeneratorDriver() {
        super(new CommonCommandLineOptions());
    }

    public static void main(String[] args) {
        new AuditLogGeneratorDriver().execute(args);
    }

    @Override
    protected void executeImpl(CommandLine cmd) {
        PropertyDefinitionListBuilder builder = new PropertyDefinitionListBuilder();
        List<PropertyDefinition> list = builder.addAws().addSwift().addMillDb().addDuracloudAuditSpace().addWorkDir().addGlobalWorkDir().build();
        new PropertyVerifier(list).verify(System.getProperties());
        SystemConfig config = SystemConfig.instance();
        config.setAuditLogSpaceId(System.getProperty("audit-log-generator.audit-log-space-id"));
        config.setSwiftAccessKey(System.getProperty("swift.accessKey"));
        config.setSwiftSecretKey(System.getProperty("swift.secretKey"));
        config.setSwiftEndpoint(System.getProperty("swift.endpoint"));
        config.setSwiftSignerType(System.getProperty("swift.signerType"));
        String workDir = System.getProperty("global.workdir");
        if (workDir == null) {
            workDir = System.getProperty("workdir");
        }
        String logRootDir = workDir + File.separator + "audit-logs";
        AuditLogGeneratorDriver.initializeLogRoot(logRootDir);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext("org.duracloud.mill");
        log.info("spring context initialized.");
        AuditLogGenerator generator = context.getBean(AuditLogGenerator.class);
        generator.execute();
        log.info("exiting...");
    }

    private static void initializeLogRoot(String logRootPath) {
        try {
            File logRootDir = new File(logRootPath);
            if (!logRootDir.exists() && !logRootDir.mkdirs()) {
                String message = "Unable to create log root dir: " + logRootDir.getAbsolutePath() + ". Please make sure that this process has permission to create this directory";
                log.error(message);
                System.exit(1);
            }
            SystemConfig.instance().setLogsDirectory(logRootPath);
        }
        catch (Exception ex) {
            log.error("failed to initialize log root dir " + logRootPath + ":" + ex.getMessage(), ex);
            System.exit(1);
        }
    }
}

