/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import java.util.List;
import org.duracloud.mill.audit.generator.LogManager;
import org.duracloud.mill.db.model.JpaAuditLogItem;
import org.duracloud.mill.db.repo.JpaAuditLogItemRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditLogGenerator {
    private static Logger log = LoggerFactory.getLogger(AuditLogGenerator.class);
    private JpaAuditLogItemRepo auditLogItemRepo;
    private LogManager logManager;

    @Autowired
    public AuditLogGenerator(JpaAuditLogItemRepo auditLogItemRepo, LogManager logManager) {
        this.auditLogItemRepo = auditLogItemRepo;
        this.logManager = logManager;
    }

    public void execute() {
        log.info("executing generator...");
        long itemsWritten = 0L;
        long totalItemsWritten = 0L;
        try {
            int maxItemsPerRequest = Integer.parseInt(System.getProperty("max-audit-items-per-request", "1000"));
            PageRequest pageRequest = PageRequest.of(0, maxItemsPerRequest);
            while (true) {
                List<JpaAuditLogItem> items;
                if (CollectionUtils.isEmpty(items = this.auditLogItemRepo.findByWrittenFalseOrderByTimestampAsc(pageRequest))) break;
                log.info("{} audit items read from the the jpa repo.", (Object)items.size());
                for (JpaAuditLogItem item : items) {
                    this.write(item);
                }
                totalItemsWritten += (itemsWritten += (long)items.size());
                log.info("{} audit items written.", (Object)items.size());
                if (itemsWritten < 100000L) continue;
                log.info("{} items written since last flush.  Flushing logs...", (Object)itemsWritten);
                this.logManager.flushLogs();
                itemsWritten = 0L;
                log.info("Purge expired...");
                this.logManager.purgeExpired();
            }
            log.info("No audit items found for processing: nowhere to go, nothing to do.");
            log.info("{} total audit items written in this run.", (Object)totalItemsWritten);
            log.info("perform final purge of expired items.");
            this.logManager.purgeExpired();
            log.info("purge complete.");
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.logManager.flushLogs();
                log.info("audit log run completed.");
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private void write(JpaAuditLogItem item) {
        this.logManager.write(item);
    }
}

