/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.util.Map;
import org.duracloud.common.queue.task.Task;
import org.duracloud.common.queue.task.TypedTask;
import org.duracloud.storage.domain.StorageProviderType;

public class BitIntegrityErrorTask
extends TypedTask {
    private static final String DESCRIPTION_KEY = "description";
    private static final String STORE_TYPE_KEY = "storeType";
    private static final String CONTENT_CHECKSUM_KEY = "contentChecksum";
    private static final String MANIFEST_CHECKSUM_CHECKSUM_KEY = "manifestChecksum";
    private static final String STORE_CHECKSUM_KEY = "storeChecksum";
    private String description;
    private StorageProviderType storeType;
    private String contentChecksum;
    private String storeChecksum;
    private String manifestChecksum;

    public Task writeTask() {
        Task task = super.writeTask();
        task.setType(Task.Type.BIT_ERROR);
        Map p = task.getProperties();
        p.put(DESCRIPTION_KEY, this.description);
        p.put(STORE_TYPE_KEY, this.storeType.name());
        p.put(CONTENT_CHECKSUM_KEY, this.contentChecksum);
        p.put(MANIFEST_CHECKSUM_CHECKSUM_KEY, this.manifestChecksum);
        p.put(STORE_CHECKSUM_KEY, this.storeChecksum);
        return task;
    }

    public void readTask(Task task) {
        super.readTask(task);
        this.description = task.getProperty(DESCRIPTION_KEY);
        this.contentChecksum = task.getProperty(CONTENT_CHECKSUM_KEY);
        this.storeChecksum = task.getProperty(STORE_CHECKSUM_KEY);
        this.storeType = StorageProviderType.valueOf((String)task.getProperty(STORE_TYPE_KEY));
        this.manifestChecksum = task.getProperty(MANIFEST_CHECKSUM_CHECKSUM_KEY);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StorageProviderType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(StorageProviderType storeType) {
        this.storeType = storeType;
    }

    public String getContentChecksum() {
        return this.contentChecksum;
    }

    public void setContentChecksum(String contentChecksum) {
        this.contentChecksum = contentChecksum;
    }

    public String getStoreChecksum() {
        return this.storeChecksum;
    }

    public void setStoreChecksum(String storeChecksum) {
        this.storeChecksum = storeChecksum;
    }

    public String getManifestChecksum() {
        return this.manifestChecksum;
    }

    public void setManifestChecksum(String manifestChecksum) {
        this.manifestChecksum = manifestChecksum;
    }
}

