/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.duracloud.mill.dup.DuplicationStorePolicy;

public class DuplicationPolicy {
    private static final ObjectMapper objMapper = new ObjectMapper();
    private Map<String, LinkedHashSet<DuplicationStorePolicy>> spaceDuplicationStorePolicies = new HashMap<String, LinkedHashSet<DuplicationStorePolicy>>();

    public Map<String, LinkedHashSet<DuplicationStorePolicy>> getSpaceDuplicationStorePolicies() {
        return this.spaceDuplicationStorePolicies;
    }

    @JsonIgnore
    public Set<String> getSpaces() {
        return this.spaceDuplicationStorePolicies.keySet();
    }

    public Set<DuplicationStorePolicy> getDuplicationStorePolicies(String spaceId) {
        return this.spaceDuplicationStorePolicies.get(spaceId);
    }

    public boolean addDuplicationStorePolicy(String spaceId, DuplicationStorePolicy dupStore) {
        LinkedHashSet<DuplicationStorePolicy> dupStores = this.spaceDuplicationStorePolicies.get(spaceId);
        if (dupStores == null) {
            dupStores = new LinkedHashSet();
            this.spaceDuplicationStorePolicies.put(spaceId, dupStores);
        }
        return dupStores.add(dupStore);
    }

    public static DuplicationPolicy unmarshall(InputStream policyStream) throws IOException {
        return (DuplicationPolicy)objMapper.readValue(policyStream, DuplicationPolicy.class);
    }

    public static String marshall(DuplicationPolicy duplicationPolicy) throws IOException {
        return objMapper.writeValueAsString((Object)duplicationPolicy);
    }
}

