/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup.util;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.constant.Constants;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.mill.config.ConfigurationManager;
import org.duracloud.mill.dup.DuplicationPolicy;
import org.duracloud.mill.dup.DuplicationStorePolicy;

public class DefaultPolicyGenerator {
    private static final String DURACLOUD_PORT = "443";
    private static final String DURACLOUD_ROOT_USER = "root";

    public DuplicationPolicy createDefaultDupPolicy(String account, String rootPass) throws ContentStoreException {
        ContentStoreManager storeManager = this.connectToDuraCloud(account, rootPass);
        Map allStores = storeManager.getContentStores();
        ContentStore primaryStore = storeManager.getPrimaryContentStore();
        String primaryStoreId = primaryStore.getStoreId();
        LinkedList<String> secondaryStoreIds = new LinkedList<String>();
        for (ContentStore store : allStores.values()) {
            String storeId = store.getStoreId();
            if (primaryStoreId.equals(storeId)) continue;
            secondaryStoreIds.add(storeId);
        }
        DuplicationPolicy defaultPolicy = new DuplicationPolicy();
        for (String spaceId : primaryStore.getSpaces()) {
            if (Constants.SYSTEM_SPACES.contains(spaceId)) continue;
            for (String storeId : secondaryStoreIds) {
                DuplicationStorePolicy dupStorePolicy = new DuplicationStorePolicy(primaryStoreId, storeId);
                defaultPolicy.addDuplicationStorePolicy(spaceId, dupStorePolicy);
            }
        }
        return defaultPolicy;
    }

    private ContentStoreManager connectToDuraCloud(String account, String rootPass) throws ContentStoreException {
        ConfigurationManager configManager = new ConfigurationManager();
        String host = configManager.getSubdomainDotDefaultDomain(account);
        ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(host, DURACLOUD_PORT);
        Credential credential = new Credential(DURACLOUD_ROOT_USER, rootPass);
        storeManager.login(credential);
        return storeManager;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new RuntimeException("Default Policy Generator expects three parameters:\n  Account subdomain\n  Account root password\n  Directory path to store policy");
        }
        String account = args[0];
        String rootPass = args[1];
        String dirPath = args[2];
        File outputDir = new File(dirPath);
        if (!outputDir.isDirectory()) {
            throw new RuntimeException("The path " + dirPath + " must point to a directory");
        }
        DefaultPolicyGenerator policyGenerator = new DefaultPolicyGenerator();
        DuplicationPolicy dupPolicy = policyGenerator.createDefaultDupPolicy(account, rootPass);
        String policyJson = DuplicationPolicy.marshall(dupPolicy);
        String policyName = account + "-duplication-policy.json";
        File policyFile = new File(outputDir, policyName);
        FileUtils.writeStringToFile((File)policyFile, (String)policyJson);
    }
}

