/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup.repo;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.duracloud.mill.dup.repo.DuplicationPolicyRepo;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.storage.domain.StorageAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftDuplicationPolicyRepo
implements DuplicationPolicyRepo {
    public static final String DUP_POLICY_REPO_BUCKET_SUFFIX = "duplication-policy-repo";
    private static final Logger log = LoggerFactory.getLogger(SwiftDuplicationPolicyRepo.class);
    private AmazonS3 s3Client;
    private String policyRepoBucketName;
    private String policyRepoBucketSuffix;

    public SwiftDuplicationPolicyRepo(String accessKey, String secretKey, String endpoint, String signer) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(StorageAccount.OPTS.SWIFT_S3_ENDPOINT.name(), endpoint);
        map.put(StorageAccount.OPTS.SWIFT_S3_SIGNER_TYPE.name(), signer);
        this.s3Client = S3ProviderUtil.getAmazonS3Client((String)accessKey, (String)secretKey, map);
        this.policyRepoBucketSuffix = DUP_POLICY_REPO_BUCKET_SUFFIX;
        this.init();
    }

    public SwiftDuplicationPolicyRepo(String accessKey, String secretKey, String endpoint, String signer, String policyRepoBucketSuffix) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(StorageAccount.OPTS.SWIFT_S3_ENDPOINT.name(), endpoint);
        map.put(StorageAccount.OPTS.SWIFT_S3_SIGNER_TYPE.name(), signer);
        this.s3Client = S3ProviderUtil.getAmazonS3Client((String)accessKey, (String)secretKey, map);
        this.policyRepoBucketSuffix = policyRepoBucketSuffix;
        this.init();
    }

    public void init() {
        List buckets = this.s3Client.listBuckets();
        for (Bucket bucket : buckets) {
            String bucketName = bucket.getName();
            if (!bucketName.endsWith(this.policyRepoBucketSuffix)) continue;
            this.policyRepoBucketName = bucketName;
        }
        if (null == this.policyRepoBucketName) {
            throw new RuntimeException("Unable to find duplication policy repo bucket in Swift. Bucket suffix: " + this.policyRepoBucketSuffix);
        }
    }

    @Override
    public InputStream getDuplicationAccounts() {
        return this.s3Client.getObject(this.policyRepoBucketName, "duplication-accounts.json").getObjectContent();
    }

    @Override
    public InputStream getDuplicationPolicy(String account) {
        return this.s3Client.getObject(this.policyRepoBucketName, account + "-duplication-policy.json").getObjectContent();
    }
}

