/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.notification;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsyncClientBuilder;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.duracloud.mill.notification.NotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SESNotificationManager
implements NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(SESNotificationManager.class);
    private String[] recipientEmailAddresses;
    private AmazonSimpleEmailService client;

    public SESNotificationManager(String[] recipientEmailAddresses, AmazonSimpleEmailService client) {
        this.recipientEmailAddresses = recipientEmailAddresses;
        if (ArrayUtils.isEmpty((Object[])this.recipientEmailAddresses)) {
            log.warn("There are no recipient emails configured. The notification manager will ignore notification requests.");
        } else {
            log.info("configured with the following recipients: {}", (Object)ArrayUtils.toString((Object)recipientEmailAddresses));
        }
        this.client = client;
    }

    public SESNotificationManager(String[] recipients) {
        this(recipients, (AmazonSimpleEmailService)AmazonSimpleEmailServiceAsyncClientBuilder.defaultClient());
    }

    @Override
    public void sendEmail(String subject, String body) {
        if (ArrayUtils.isEmpty((Object[])this.recipientEmailAddresses)) {
            log.warn("No recipients configured - no one to notify: ignoring...");
            return;
        }
        SendEmailRequest email = new SendEmailRequest();
        try {
            Destination destination = new Destination();
            destination.setToAddresses(Arrays.asList(this.recipientEmailAddresses));
            email.setDestination(destination);
            email.setSource(System.getProperty("notification.sender", "no-sender-specified"));
            Message message = new Message(new Content(subject), new Body(new Content(body)));
            email.setMessage(message);
            this.client.sendEmail(email);
            log.info("email sent: {}", (Object)email);
        }
        catch (Exception e) {
            log.error("failed to send " + email + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

