/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.mill.util.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyVerifier {
    private static Logger log = LoggerFactory.getLogger(PropertyVerifier.class);
    private Collection<PropertyDefinition> propDefs;

    public PropertyVerifier(Collection<PropertyDefinition> propDefs) {
        if (propDefs == null || propDefs.size() == 0) {
            throw new IllegalArgumentException("propDefs must contain at least one property definition.");
        }
        this.propDefs = propDefs;
    }

    public Collection<PropertyDefinition> validateProperties(Properties properties) {
        LinkedList<PropertyDefinition> failedDefinitions = new LinkedList<PropertyDefinition>();
        for (PropertyDefinition def : this.propDefs) {
            String value = properties.getProperty(def.getName());
            if (def.isRequired() && null == value) {
                failedDefinitions.add(def);
                continue;
            }
            if (def.getValidValues().size() <= 0 || null == value || def.getValidValues().contains(value)) continue;
            failedDefinitions.add(def);
        }
        return failedDefinitions;
    }

    public void logFailuresAndThrowRuntime(Collection<PropertyDefinition> failures) {
        StringBuilder error = new StringBuilder("The property file is missing required field and/or contains invalid values. See below for details:");
        for (PropertyDefinition def : failures) {
            Object validValues = "";
            error.append("\n");
            if (def.getValidValues().size() > 0) {
                validValues = ", valid values: (" + StringUtils.join(def.getValidValues(), (String)" | ") + ")";
            }
            error.append(MessageFormat.format("    property:  {0}, required: {1} {2}", def.getName(), def.isRequired(), validValues));
        }
        throw new RuntimeException(error.toString());
    }

    public void logValues(Properties props) {
        StringBuilder message = new StringBuilder("Current configuration:");
        for (PropertyDefinition def : this.propDefs) {
            message.append("\n");
            String value = props.getProperty(def.getName());
            if (def.isSensitive()) {
                value = "*****************";
            }
            message.append(MessageFormat.format("    {0}: {1}", def.getName(), value));
        }
        log.info(message.toString());
    }

    public void verify(Properties properties) {
        Collection<PropertyDefinition> failures = this.validateProperties(properties);
        if (failures.size() > 0) {
            this.logFailuresAndThrowRuntime(failures);
        } else {
            this.logValues(properties);
        }
    }
}

