/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.notification;

import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.duracloud.mill.config.ConfigurationManager;
import org.duracloud.mill.notification.NotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SMTPNotificationManager
implements NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(SMTPNotificationManager.class);
    private JavaMailSenderImpl emailService;
    private String[] recipientEmailAddresses;
    private String sender;

    public SMTPNotificationManager(String[] recipientEmailAddresses, ConfigurationManager configurationManager) {
        this.recipientEmailAddresses = recipientEmailAddresses;
        if (ArrayUtils.isEmpty((Object[])this.recipientEmailAddresses)) {
            log.warn("There are no recipient emails configured. The notification manager will ignore notification requests.");
            return;
        }
        log.info("configured with the following recipients: {}", (Object)ArrayUtils.toString((Object)recipientEmailAddresses));
        String[] emailConfig = configurationManager.getSMTPConfig();
        String host = emailConfig[0];
        String port = emailConfig[1];
        String username = emailConfig[2];
        String password = emailConfig[3];
        this.sender = emailConfig[4].trim();
        this.emailService = new JavaMailSenderImpl();
        Properties mailProperties = new Properties();
        if (username != null) {
            mailProperties.put("mail.smtp.auth", "true");
            this.emailService.setUsername(username.trim());
            this.emailService.setPassword(password.trim());
        }
        mailProperties.put("mail.smtp.starttls.enable", "true");
        mailProperties.put("mail.smtp.starttls.required", "true");
        this.emailService.setJavaMailProperties(mailProperties);
        this.emailService.setProtocol("smtp");
        this.emailService.setHost(host.trim());
        if (port == null || port.isEmpty()) {
            port = "25";
        }
        this.emailService.setPort(Integer.parseInt(port.trim()));
        try {
            this.emailService.testConnection();
            log.debug("Email connection test passed: email service with Sprint email client connected to {}, Port: {}, User: {}.", new Object[]{host, port, username});
        }
        catch (MessagingException ex) {
            log.error("Email connection test failed when connecting to {}, Port: {}, User: {}, because {}", new Object[]{host, port, username, ex.getMessage()});
        }
    }

    @Override
    public void sendEmail(String subject, String body) {
        if (ArrayUtils.isEmpty((Object[])this.recipientEmailAddresses)) {
            log.warn("No recipients configured - no one to notify: ignoring...");
            return;
        }
        MimeMessage message = this.emailService.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(message);
        try {
            messageHelper.setFrom(this.sender);
            messageHelper.setSubject(subject);
            messageHelper.setTo(this.recipientEmailAddresses);
            messageHelper.setText(body, false);
        }
        catch (MessagingException ex) {
            log.error("Failed to prepare email message {}", (Object)ex.getMessage());
        }
        try {
            this.emailService.send(message);
        }
        catch (MailException ex) {
            log.error("Failed to send email because: {}", (Object)ex.getMessage());
        }
    }
}

