/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.credentials.impl;

import java.text.MessageFormat;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.mill.credentials.impl.MCJpaPropertiesVerifier;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.dialect.MySQL5Dialect;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.account.db"}, entityManagerFactoryRef="credentialsRepoEntityManagerFactory", transactionManagerRef="credentialsJpaRepoTransactionManager")
@EnableTransactionManagement
public class CredentialsRepoConfig {
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "credentialsRepoEntityManagerFactory";
    public static final String CREDENTIALS_REPO_DATA_SOURCE_BEAN = "credentialsRepoDataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "credentialsJpaRepoTransactionManager";

    @Bean(name={"credentialsRepoDataSource"}, destroyMethod="close")
    public BasicDataSource credentialsRepoDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}", System.getProperty("db.host", "localhost"), System.getProperty("db.port", "3306"), System.getProperty("db.name", "mill")));
        dataSource.setUsername(System.getProperty("db.user", "mill"));
        dataSource.setPassword(System.getProperty("db.pass", "password"));
        dataSource.setInitialSize(5);
        dataSource.setMaxIdle(5);
        dataSource.setMaxTotal(50);
        dataSource.setMaxConnLifetimeMillis(14400L);
        dataSource.setTimeBetweenEvictionRunsMillis(900000L);
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    @Bean(name={"credentialsJpaRepoTransactionManager"})
    public PlatformTransactionManager credentialsRepoTransactionManager(@Qualifier(value="credentialsRepoEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"credentialsRepoEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean credentialsRepoEntityManagerFactory(@Qualifier(value="credentialsRepoDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("credentials-repo-pu");
        emf.setPackagesToScan(new String[]{"org.duracloud.account.db.model"});
        HibernateJpaVendorAdapter va = new HibernateJpaVendorAdapter();
        va.setDatabase(Database.MYSQL);
        emf.setJpaVendorAdapter((JpaVendorAdapter)va);
        Properties props = new Properties();
        props.setProperty("hibernate.hbm2ddl.auto", "validate");
        props.setProperty("hibernate.dialect", MySQL5Dialect.class.getName());
        props.setProperty("hibernate.ejb.naming_strategy", ImprovedNamingStrategy.class.getName());
        props.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        props.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
        props.setProperty("jadira.usertype.databaseZone", "jvm");
        props.setProperty("hibernate.show_sql", System.getProperty("hibernate.show_sql", "false"));
        props.setProperty("hibernate.format_sql", System.getProperty("hibernate.format_sql", "false"));
        props.setProperty("hibernate.show_comments", "false");
        emf.setJpaProperties(props);
        return emf;
    }

    static {
        new MCJpaPropertiesVerifier().verify();
    }
}

