/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;

public class SupplyKeyMatchingValueOrNull<K, V>
implements Supplier<K> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<K, Supplier<V>>> supplier;
    private final Supplier<V> valueSupplier;

    public SupplyKeyMatchingValueOrNull(Supplier<Map<K, Supplier<V>>> supplier, Supplier<V> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.supplier = supplier;
    }

    @Override
    public K get() {
        V uri = this.valueSupplier.get();
        Map map = Maps.transformValues(this.supplier.get(), Suppliers.supplierFunction());
        Object region = ((ImmutableMap)((Object)ImmutableBiMap.copyOf(map).inverse())).get(uri);
        if (region == null && map.size() > 0) {
            region = Iterables.get(map.keySet(), 0);
            this.logger.warn("failed to find key for value %s in %s; choosing first: %s", uri, map, region);
        }
        return (K)region;
    }
}

