/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull(em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public <T> AbstractJPAQuery<T, JPAQuery<T>> createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, (JPQLTemplates)OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public AbstractJPAQuery<Object, JPAQuery<Object>> createQuery(EntityPath<?> ... paths) {
        return (AbstractJPAQuery)this.createQuery().from(paths);
    }

    public <T> JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public <T> JPQLQuery<T> applySorting(Sort sort, JPQLQuery<T> query) {
        if (sort == null) {
            return query;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private <T> JPQLQuery<T> addOrderByFrom(QSort qsort, JPQLQuery<T> query) {
        List<OrderSpecifier<?>> orderSpecifiers = qsort.getOrderSpecifiers();
        return (JPQLQuery)query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[orderSpecifiers.size()]));
    }

    private <T> JPQLQuery<T> addOrderByFrom(Sort sort, JPQLQuery<T> query) {
        Assert.notNull(sort, "Sort must not be null!");
        Assert.notNull(query, "Query must not be null!");
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), this.toQueryDslNullHandling(order.getNullHandling()));
    }

    private OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, "NullHandling must not be null!");
        switch (nullHandling) {
            case NULLS_FIRST: {
                return OrderSpecifier.NullHandling.NullsFirst;
            }
            case NULLS_LAST: {
                return OrderSpecifier.NullHandling.NullsLast;
            }
        }
        return OrderSpecifier.NullHandling.Default;
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull(order, "Order must not be null!");
        Object sortPropertyExpression = this.builder;
        for (PropertyPath path = PropertyPath.from(order.getProperty(), this.builder.getType()); path != null; path = path.next()) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()).lower() : Expressions.path(path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
        }
        return sortPropertyExpression;
    }
}

