/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.io.File;
import java.io.IOException;
import org.duracloud.mill.util.SystemPropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileHelper {
    private static Logger log = LoggerFactory.getLogger(PropertyFileHelper.class);

    public static void loadFromSystemProperty(String propertyFileSystemProperty, String defaultPropertyFilePath) {
        String path = System.getProperty(propertyFileSystemProperty);
        if (path == null) {
            path = defaultPropertyFilePath;
            System.setProperty(propertyFileSystemProperty, path);
            log.info("Using default " + propertyFileSystemProperty + " value: " + path + ".  To override default specify java commandline param -D" + propertyFileSystemProperty + "=/your/prop/file/path/here");
        } else {
            log.info("Using user-defined " + propertyFileSystemProperty + " property: " + path);
        }
        if (!new File(path).exists()) {
            log.error(path + " does not exist. It is required to run this application. Exiting...");
            System.exit(1);
        } else {
            try {
                SystemPropertyLoader.load(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

