/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rest.RestApiMetadata;

public class ApiPredicates {
    public static Predicate<ApiMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<ApiMetadata> id(final String id) {
        Preconditions.checkNotNull(Strings.emptyToNull(id), "id must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                return apiMetadata.getId().equals(id);
            }

            public String toString() {
                return "id(" + id + ")";
            }
        };
    }

    public static Predicate<RestApiMetadata> apiAssignableFrom(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, "type must be defined");
        return new Predicate<RestApiMetadata>(){

            @Override
            public boolean apply(RestApiMetadata apiMetadata) {
                return type.isAssignableFrom(apiMetadata.getApi());
            }

            public String toString() {
                return "contextAssignableFrom(" + type + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> contextAssignableFrom(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, "context must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                return type.isAssignableFrom(apiMetadata.getContext());
            }

            public String toString() {
                return "contextAssignableFrom(" + type + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> viewableAs(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, "context must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                for (TypeToken<? extends View> to : apiMetadata.getViews()) {
                    if (!type.isAssignableFrom(to)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "viewableAs(" + type + ")";
            }
        };
    }
}

