/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.PhantomPayload;

public class BlobBuilderImpl
implements BlobBuilder {
    private Payload payload;
    private String name;
    private Map<String, String> userMetadata = Maps.newLinkedHashMap();
    private StorageType type = StorageType.BLOB;

    @Override
    public BlobBuilder name(String name) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkArgument(!name.isEmpty(), "name");
        this.name = name;
        return this;
    }

    @Override
    public BlobBuilder type(StorageType type) {
        this.type = type;
        return this;
    }

    @Override
    public BlobBuilder userMetadata(Map<String, String> userMetadata) {
        if (userMetadata != null) {
            this.userMetadata = Maps.newLinkedHashMap(userMetadata);
        }
        return this;
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(Payload payload) {
        this.payload = payload;
        return new PayloadBlobBuilderImpl(this, payload);
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(InputStream data) {
        return this.payload(Payloads.newPayload(Preconditions.checkNotNull(data, "data")));
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(byte[] data) {
        return this.payload(Payloads.newPayload(Preconditions.checkNotNull(data, "data")));
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(ByteSource data) {
        return this.payload(Payloads.newPayload(Preconditions.checkNotNull(data, "data")));
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(String data) {
        return this.payload(Payloads.newPayload(Preconditions.checkNotNull(data, "data")));
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder payload(File data) {
        return this.payload(Payloads.newPayload(Preconditions.checkNotNull(data, "data")));
    }

    @Override
    public Blob build() {
        BlobImpl blob = new BlobImpl(new MutableBlobMetadataImpl());
        Preconditions.checkState(this.name != null, "name");
        blob.getMetadata().setName(this.name);
        if (this.payload != null) {
            blob.setPayload(this.payload);
        }
        blob.getMetadata().setUserMetadata(this.userMetadata);
        blob.getMetadata().setType(this.type);
        return blob;
    }

    @Override
    public BlobBuilder.PayloadBlobBuilder forSigning() {
        return this.payload(new PhantomPayload());
    }

    public static class PayloadBlobBuilderImpl
    implements BlobBuilder.PayloadBlobBuilder {
        private final BlobBuilder builder;
        private final Payload payload;

        public PayloadBlobBuilderImpl(BlobBuilder builder, Payload payload) {
            this.builder = Preconditions.checkNotNull(builder, "builder");
            this.payload = Preconditions.checkNotNull(payload, "payload");
        }

        @Override
        public BlobBuilder name(String name) {
            return this.builder.name(name);
        }

        @Override
        public BlobBuilder type(StorageType type) {
            return this.builder.type(type);
        }

        @Override
        public BlobBuilder userMetadata(Map<String, String> userMetadata) {
            return this.builder.userMetadata(userMetadata);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(Payload payload) {
            return this.builder.payload(payload);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(InputStream payload) {
            return this.builder.payload(payload);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(byte[] payload) {
            return this.builder.payload(payload);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(ByteSource payload) {
            return this.builder.payload(payload);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(String payload) {
            return this.builder.payload(payload);
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder payload(File payload) {
            return this.builder.payload(payload);
        }

        @Override
        public Blob build() {
            return this.builder.build();
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentLength(long contentLength) {
            Preconditions.checkArgument(contentLength >= 0L, "content length must be non-negative");
            this.payload.getContentMetadata().setContentLength(contentLength);
            return this;
        }

        @Override
        @Deprecated
        public BlobBuilder.PayloadBlobBuilder contentMD5(byte[] md5) {
            return this.contentMD5(md5 == null ? null : HashCode.fromBytes(md5));
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentMD5(HashCode md5) {
            this.payload.getContentMetadata().setContentMD5(md5);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentType(MediaType contentType) {
            return this.contentType(Preconditions.checkNotNull(contentType, "contentType").toString());
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentType(String contentType) {
            this.payload.getContentMetadata().setContentType(contentType);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentDisposition(String contentDisposition) {
            this.payload.getContentMetadata().setContentDisposition(contentDisposition);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentLanguage(String contentLanguage) {
            this.payload.getContentMetadata().setContentLanguage(contentLanguage);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder contentEncoding(String contentEncoding) {
            this.payload.getContentMetadata().setContentEncoding(contentEncoding);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder expires(Date expires) {
            this.payload.getContentMetadata().setExpires(expires);
            return this;
        }

        @Override
        public BlobBuilder.PayloadBlobBuilder forSigning() {
            return this.builder.forSigning();
        }
    }
}

