/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.options.CreateUserOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateUserOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface UserAdminAsyncApi {
    @Named(value="user:create")
    @POST
    @Path(value="/users")
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2);

    @Named(value="user:create")
    @POST
    @Path(value="/users")
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @MapBinder(value=CreateUserOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2, CreateUserOptions var3);

    @Named(value="user:delete")
    @DELETE
    @Path(value="/users/{id}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="user:updateuser")
    @PUT
    @Path(value="/users/{id}")
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @MapBinder(value=UpdateUserOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> update(@PathParam(value="id") String var1, UpdateUserOptions var2);
}

