/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.Binder;

@Singleton
public class BindSwiftObjectMetadataToRequest
implements Binder {
    private final BindUserMetadataToHeadersWithPrefix mdBinder;
    private final ObjectToBlob object2Blob;

    @Inject
    public BindSwiftObjectMetadataToRequest(ObjectToBlob object2Blob, BindUserMetadataToHeadersWithPrefix mdBinder) {
        this.mdBinder = mdBinder;
        this.object2Blob = object2Blob;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Date expires;
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof SwiftObject, "this binder is only valid for SwiftObject!");
        Preconditions.checkNotNull(request, "request");
        SwiftObject object = (SwiftObject)input;
        if (object.getPayload().getContentMetadata().getContentType() == null) {
            object.getPayload().getContentMetadata().setContentType("application/octet-stream");
        }
        if (object.getPayload().getContentMetadata().getContentLength() != null && object.getPayload().getContentMetadata().getContentLength() >= 0L) {
            Preconditions.checkArgument(object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L, "maximum size for put object is 5GB");
        } else {
            request = ((HttpRequest.Builder)((HttpRequest)request).toBuilder().replaceHeader("Transfer-Encoding", "chunked")).build();
        }
        byte[] contentMD5 = object.getInfo().getHash();
        if (contentMD5 != null) {
            request = ((HttpRequest.Builder)((HttpRequest)request).toBuilder().addHeader("ETag", BaseEncoding.base16().lowerCase().encode(contentMD5))).build();
        }
        if ((expires = object.getPayload().getContentMetadata().getExpires()) != null) {
            request = ((HttpRequest.Builder)((HttpRequest)request).toBuilder().addHeader("X-Delete-At", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(expires.getTime())))).build();
        }
        request = this.mdBinder.bindToRequest(request, this.object2Blob.apply(object));
        return (R)request;
    }
}

