/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.storagestats;

import java.io.File;
import java.util.List;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.impl.ApplicationContextLocator;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.LoopingTaskProducerDriverSupport;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.storagestats.LoopingStorageStatsTaskProducer;
import org.duracloud.mill.ltp.storagestats.LoopingStorageStatsTaskProducerConfigurationManager;
import org.duracloud.mill.ltp.storagestats.StorageStatsMorsel;
import org.duracloud.mill.notification.SESNotificationManager;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AppDriver
extends LoopingTaskProducerDriverSupport {
    private static Logger log = LoggerFactory.getLogger(AppDriver.class);

    public AppDriver() {
        super(new CommonCommandLineOptions());
    }

    public static void main(String[] args) {
        new AppDriver().execute(args);
    }

    private void processExclusionListOption() {
        File list;
        String exclusionList = System.getProperty("looping.storagestats.exclusion-list-file");
        if (exclusionList != null && !(list = new File(exclusionList)).exists()) {
            throw new DuraCloudRuntimeException("exclusion list not found: " + list);
        }
    }

    private void processInclusionListOption() {
        File list;
        String inclusionList = System.getProperty("looping.storagestats.inclusion-list-file");
        if (inclusionList != null && !(list = new File(inclusionList)).exists()) {
            throw new DuraCloudRuntimeException("inclusionlist not found: " + list);
        }
    }

    @Override
    protected LoopingTaskProducer buildTaskProducer() {
        List<PropertyDefinition> defintions = new PropertyDefinitionListBuilder().addAws().addNotifications().addMcDb().addLoopingStorageStatsFrequency().addLoopingStorageStatsMaxQueueSize().addLoopingStorageStatsStartTime().addStorageStatsQueue().addWorkDir().build();
        PropertyVerifier verifier = new PropertyVerifier(defintions);
        verifier.verify(System.getProperties());
        this.processExclusionListOption();
        this.processInclusionListOption();
        LoopingStorageStatsTaskProducerConfigurationManager config = new LoopingStorageStatsTaskProducerConfigurationManager();
        ApplicationContext ctx = ApplicationContextLocator.get();
        CredentialsRepo credentialsRepo = ctx.getBean(CredentialsRepo.class);
        StorageProviderFactory storageProviderFactory = new StorageProviderFactory();
        SESNotificationManager notificationMananger = new SESNotificationManager(config.getNotificationRecipients());
        SQSTaskQueue queue = new SQSTaskQueue(config.getStorageStatsQueue());
        String stateFilePath = new File(config.getWorkDirectoryPath(), "storagestats-producer-state.json").getAbsolutePath();
        StateManager<StorageStatsMorsel> stateManager = new StateManager<StorageStatsMorsel>(stateFilePath, StorageStatsMorsel.class);
        LoopingStorageStatsTaskProducer producer = new LoopingStorageStatsTaskProducer(credentialsRepo, storageProviderFactory, queue, stateManager, this.getMaxQueueSize("looping.storagestats.max-task-queue-size"), this.getFrequency("looping.storagestats.frequency"), this.getStartTime("looping.storagestats.start-time"), notificationMananger, config.getPathFilterManager(), config);
        return producer;
    }
}

