/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.model.Credential;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.storage.provider.TaskRunner;

public abstract class AbstractSnapshotTaskRunner
implements TaskRunner {
    private String bridgeAppHost;
    private String bridgeAppPort;
    private String bridgeAppUser;
    private String bridgeAppPass;

    public AbstractSnapshotTaskRunner(String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        this.bridgeAppHost = bridgeAppHost;
        this.bridgeAppPort = bridgeAppPort;
        this.bridgeAppUser = bridgeAppUser;
        this.bridgeAppPass = bridgeAppPass;
    }

    protected String getBridgeAppHost() {
        return this.bridgeAppHost;
    }

    protected String getBridgeAppPort() {
        return this.bridgeAppPort;
    }

    protected String getBridgeAppUser() {
        return this.bridgeAppUser;
    }

    protected String getBridgeAppPass() {
        return this.bridgeAppPass;
    }

    protected String buildBridgeBaseURL() {
        String protocol = "443".equals(this.bridgeAppPort) ? "https" : "http";
        return MessageFormat.format("{0}://{1}:{2}/bridge", protocol, this.bridgeAppHost, this.bridgeAppPort);
    }

    protected RestHttpHelper createRestHelper() {
        RestHttpHelper restHelper = new RestHttpHelper(new Credential(this.bridgeAppUser, this.bridgeAppPass));
        return restHelper;
    }

    protected <T> T getValueFromJson(String json, String propName) throws IOException {
        return (T)this.jsonStringToMap(json).get(propName);
    }

    protected Map jsonStringToMap(String json) throws IOException {
        return new JaxbJsonSerializer<HashMap>(HashMap.class).deserialize(json);
    }

    protected String getMessageValue(String json) throws IOException {
        return (String)this.getValueFromJson(json, "message");
    }
}

