/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.util.Assert;

public final class CsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final CsrfTokenRepository csrfTokenRepository;

    public CsrfAuthenticationStrategy(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull(csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        boolean containsToken;
        boolean bl = containsToken = this.csrfTokenRepository.loadToken(request) != null;
        if (containsToken) {
            this.csrfTokenRepository.saveToken(null, request, response);
            CsrfToken newToken = this.csrfTokenRepository.generateToken(request);
            SaveOnAccessCsrfToken tokenForRequest = new SaveOnAccessCsrfToken(this.csrfTokenRepository, request, response, newToken);
            request.setAttribute(CsrfToken.class.getName(), (Object)tokenForRequest);
            request.setAttribute(newToken.getParameterName(), (Object)tokenForRequest);
        }
    }

    private static final class SaveOnAccessCsrfToken
    implements CsrfToken {
        private transient CsrfTokenRepository tokenRepository;
        private transient HttpServletRequest request;
        private transient HttpServletResponse response;
        private final CsrfToken delegate;

        public SaveOnAccessCsrfToken(CsrfTokenRepository tokenRepository, HttpServletRequest request, HttpServletResponse response, CsrfToken delegate) {
            this.tokenRepository = tokenRepository;
            this.request = request;
            this.response = response;
            this.delegate = delegate;
        }

        public String getHeaderName() {
            return this.delegate.getHeaderName();
        }

        public String getParameterName() {
            return this.delegate.getParameterName();
        }

        public String getToken() {
            this.saveTokenIfNecessary();
            return this.delegate.getToken();
        }

        public String toString() {
            return "SaveOnAccessCsrfToken [delegate=" + this.delegate + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SaveOnAccessCsrfToken other = (SaveOnAccessCsrfToken)obj;
            return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveTokenIfNecessary() {
            if (this.tokenRepository == null) {
                return;
            }
            SaveOnAccessCsrfToken saveOnAccessCsrfToken = this;
            synchronized (saveOnAccessCsrfToken) {
                if (this.tokenRepository != null) {
                    this.tokenRepository.saveToken(this.delegate, this.request, this.response);
                    this.tokenRepository = null;
                    this.request = null;
                    this.response = null;
                }
            }
        }
    }
}

