/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.storagestats;

import java.time.LocalTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.common.storageprovider.StorageStatsTask;
import org.duracloud.mill.credentials.AccountCredentials;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.PathFilterManager;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.storagestats.LoopingStorageStatsTaskProducerConfigurationManager;
import org.duracloud.mill.ltp.storagestats.StorageStatsMorsel;
import org.duracloud.mill.ltp.storagestats.StorageStatsRunStats;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingStorageStatsTaskProducer
extends LoopingTaskProducer<StorageStatsMorsel> {
    private static Logger log = LoggerFactory.getLogger(LoopingStorageStatsTaskProducer.class);
    private PathFilterManager exclusionManager;
    private int waitTimeInMsBeforeQueueSizeCheck = 10000;

    public LoopingStorageStatsTaskProducer(CredentialsRepo credentialsRepo, StorageProviderFactory storageProviderFactory, TaskQueue queue, StateManager<StorageStatsMorsel> state, int maxTaskQueueSize, Frequency frequency, LocalTime startTime, NotificationManager notificationManager, PathFilterManager exclusionManager, LoopingStorageStatsTaskProducerConfigurationManager config) {
        super(credentialsRepo, storageProviderFactory, queue, state, maxTaskQueueSize, frequency, startTime, notificationManager, config);
        this.exclusionManager = exclusionManager;
    }

    @Override
    protected void loadMorselQueueFromSource(Queue<StorageStatsMorsel> morselQueue) {
        try {
            for (String account : this.getAccountsList()) {
                String accountPath = "/" + account;
                log.debug("loading {}", (Object)account);
                if (this.exclusionManager.isExcluded(accountPath)) continue;
                AccountCredentials accountCreds = this.getCredentialsRepo().getAccountCredentials(account);
                for (StorageProviderCredentials cred : accountCreds.getProviderCredentials()) {
                    String storePath = accountPath + "/" + cred.getProviderId();
                    if (this.exclusionManager.isExcluded(storePath)) continue;
                    StorageProvider store = this.getStorageProvider(cred);
                    Iterator<String> spaces = store.getSpaces();
                    while (spaces.hasNext()) {
                        String spaceId = spaces.next();
                        String spacePath = storePath + "/" + spaceId;
                        if (this.exclusionManager.isExcluded(spacePath)) continue;
                        morselQueue.add(new StorageStatsMorsel(account, cred.getProviderId(), cred.getProviderType().name(), spaceId));
                    }
                    log.info("loaded {} into morsel queue.", (Object)account);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DuraCloudRuntimeException(e);
        }
    }

    private List<String> getAccountsList() throws CredentialsRepoException {
        return this.getCredentialsRepo().getActiveAccounts();
    }

    @Override
    protected void nibble(Queue<StorageStatsMorsel> queue) {
        StorageStatsMorsel morsel = queue.peek();
        String storeId = morsel.getStoreId();
        StorageProvider store = this.getStorageProvider(morsel.getAccount(), storeId);
        int maxTaskQueueSize = this.getMaxTaskQueueSize();
        int taskQueueSize = this.getTaskQueue().size();
        if (taskQueueSize >= maxTaskQueueSize) {
            log.info("Task queue size ({}) has reached or exceeded max size ({}).", (Object)taskQueueSize, (Object)maxTaskQueueSize);
        } else {
            this.addTask(morsel, store);
            queue.remove(morsel);
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void addTask(StorageStatsMorsel morsel, StorageProvider store) {
        String account = morsel.getAccount();
        String storeId = morsel.getStoreId();
        String spaceId = morsel.getSpaceId();
        StorageStatsTask storageStatsTask = new StorageStatsTask();
        storageStatsTask.setAccount(account);
        storageStatsTask.setSpaceId(spaceId);
        storageStatsTask.setStoreId(storeId);
        Task task = storageStatsTask.writeTask();
        this.getTaskQueue().put(task);
        ((StorageStatsRunStats)this.getStats(account)).add(1);
    }

    @Override
    protected void logIncrementalStatsByAccount(String account, RunStats stats) {
        log.info("Session stats by account (incremental): account={} tasksAdded={}", (Object)account, (Object)((StorageStatsRunStats)stats).getAdded());
    }

    @Override
    protected void logCumulativeSessionStats(Map<String, RunStats> runstats, RunStats cumulativeTotals) {
        log.info("session stats (global cumulative): domains={} tasksAdded={}", (Object)runstats.keySet().size(), (Object)((StorageStatsRunStats)cumulativeTotals).getAdded());
    }

    @Override
    protected void logGlobalncrementalStats(RunStats incrementalTotals) {
        log.info("Session stats (global incremental): tasksAdded={}", (Object)((StorageStatsRunStats)incrementalTotals).getAdded());
    }

    @Override
    protected RunStats createRunStats() {
        return new StorageStatsRunStats();
    }

    public void setWaitTimeInMsBeforeQueueSizeCheck(int ms) {
        this.waitTimeInMsBeforeQueueSizeCheck = ms;
    }

    @Override
    protected String getLoopingProducerTypePrefix() {
        return "storagestats";
    }
}

