/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.spi;

import java.util.Map;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;

public final class ProviderChecker {
    private static final Logger log = Logger.getLogger(ProviderChecker.class);
    private static String[] HIBERNATE_PROVIDER_NAMES = new String[]{HibernatePersistenceProvider.class.getName(), HibernatePersistence.class.getName()};

    public static boolean isProvider(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        return ProviderChecker.hibernateProviderNamesContain(ProviderChecker.extractRequestedProviderName(persistenceUnit, integration));
    }

    public static boolean hibernateProviderNamesContain(String requestedProviderName) {
        log.tracef("Checking requested PersistenceProvider name [%s] against Hibernate provider names", (Object)requestedProviderName);
        for (String hibernateProviderName : HIBERNATE_PROVIDER_NAMES) {
            if (!requestedProviderName.equals(hibernateProviderName)) continue;
            return true;
        }
        log.tracef("Found no match against Hibernate provider names", new Object[0]);
        return false;
    }

    public static String extractRequestedProviderName(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        String integrationProviderName = ProviderChecker.extractProviderName(integration);
        if (integrationProviderName != null) {
            log.debugf("Integration provided explicit PersistenceProvider [%s]", (Object)integrationProviderName);
            return integrationProviderName;
        }
        String persistenceUnitRequestedProvider = ProviderChecker.extractProviderName(persistenceUnit);
        if (persistenceUnitRequestedProvider != null) {
            log.debugf("Persistence-unit [%s] requested PersistenceProvider [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnitRequestedProvider);
            return persistenceUnitRequestedProvider;
        }
        log.debug("No PersistenceProvider explicitly requested, assuming Hibernate");
        return HibernatePersistenceProvider.class.getName();
    }

    private static String extractProviderName(Map integration) {
        if (integration == null) {
            return null;
        }
        String setting = (String)integration.get("javax.persistence.provider");
        return setting == null ? null : setting.trim();
    }

    private static String extractProviderName(PersistenceUnitDescriptor persistenceUnit) {
        String persistenceUnitRequestedProvider = persistenceUnit.getProviderClassName();
        return persistenceUnitRequestedProvider == null ? null : persistenceUnitRequestedProvider.trim();
    }

    private ProviderChecker() {
    }
}

