/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup.repo;

import java.io.File;
import java.io.InputStream;
import org.duracloud.common.util.IOUtil;
import org.duracloud.mill.dup.repo.DuplicationPolicyRepo;

public class LocalDuplicationPolicyRepo
implements DuplicationPolicyRepo {
    private File repoDir;

    public LocalDuplicationPolicyRepo(String repoDirPath) {
        this.repoDir = new File(repoDirPath);
        if (!this.repoDir.exists() || !this.repoDir.isDirectory()) {
            throw new RuntimeException("Path " + repoDirPath + " does not point to a duplication policy directory");
        }
    }

    @Override
    public InputStream getDuplicationAccounts() {
        File accountsFile = new File(this.repoDir, "duplication-accounts.json");
        return IOUtil.getFileStream(accountsFile);
    }

    @Override
    public InputStream getDuplicationPolicy(String account) {
        File policyFile = new File(this.repoDir, account + "-duplication-policy.json");
        return IOUtil.getFileStream(policyFile);
    }
}

