/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup.repo;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import java.io.InputStream;
import java.util.List;
import org.duracloud.mill.dup.repo.DuplicationPolicyRepo;

public class S3DuplicationPolicyRepo
implements DuplicationPolicyRepo {
    public static final String DUP_POLICY_REPO_BUCKET_SUFFIX = "duplication-policy-repo";
    private AmazonS3 s3Client;
    private String policyRepoBucketName;
    private String policyRepoBucketSuffix;

    public S3DuplicationPolicyRepo() {
        this.s3Client = (AmazonS3)AmazonS3ClientBuilder.standard().build();
        this.policyRepoBucketSuffix = DUP_POLICY_REPO_BUCKET_SUFFIX;
        this.init();
    }

    public S3DuplicationPolicyRepo(String policyRepoBucketSuffix) {
        this((AmazonS3)AmazonS3ClientBuilder.standard().build(), policyRepoBucketSuffix);
    }

    public S3DuplicationPolicyRepo(AmazonS3 s3Client, String policyRepoBucketSuffix) {
        this.s3Client = s3Client;
        this.policyRepoBucketSuffix = policyRepoBucketSuffix;
        this.init();
    }

    public S3DuplicationPolicyRepo(AmazonS3 s3Client) {
        this(s3Client, DUP_POLICY_REPO_BUCKET_SUFFIX);
    }

    private void init() {
        List<Bucket> buckets = this.s3Client.listBuckets();
        for (Bucket bucket : buckets) {
            String bucketName = bucket.getName();
            if (!bucketName.endsWith(this.policyRepoBucketSuffix)) continue;
            this.policyRepoBucketName = bucketName;
        }
        if (null == this.policyRepoBucketName) {
            throw new RuntimeException("Unable to find duplication policy repo bucket in S3. Bucket suffix: " + this.policyRepoBucketSuffix);
        }
    }

    @Override
    public InputStream getDuplicationAccounts() {
        return this.s3Client.getObject(this.policyRepoBucketName, "duplication-accounts.json").getObjectContent();
    }

    @Override
    public InputStream getDuplicationPolicy(String account) {
        return this.s3Client.getObject(this.policyRepoBucketName, account + "-duplication-policy.json").getObjectContent();
    }
}

