/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CachePolicy;
import com.amazonaws.services.cloudfront.model.transform.CachePolicyConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CachePolicyStaxUnmarshaller
implements Unmarshaller<CachePolicy, StaxUnmarshallerContext> {
    private static CachePolicyStaxUnmarshaller instance;

    @Override
    public CachePolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        CachePolicy cachePolicy = new CachePolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cachePolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    cachePolicy.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    cachePolicy.setLastModifiedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CachePolicyConfig", targetDepth)) continue;
                cachePolicy.setCachePolicyConfig(CachePolicyConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cachePolicy;
    }

    public static CachePolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CachePolicyStaxUnmarshaller();
        }
        return instance;
    }
}

