/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginGroupMember;
import com.amazonaws.services.cloudfront.model.OriginGroupMembers;
import com.amazonaws.services.cloudfront.model.transform.OriginGroupMemberStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class OriginGroupMembersStaxUnmarshaller
implements Unmarshaller<OriginGroupMembers, StaxUnmarshallerContext> {
    private static OriginGroupMembersStaxUnmarshaller instance;

    @Override
    public OriginGroupMembers unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginGroupMembers originGroupMembers = new OriginGroupMembers();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originGroupMembers;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    originGroupMembers.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    originGroupMembers.withItems(new ArrayList<OriginGroupMember>());
                    continue;
                }
                if (!context.testExpression("Items/OriginGroupMember", targetDepth)) continue;
                originGroupMembers.withItems(OriginGroupMemberStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originGroupMembers;
    }

    public static OriginGroupMembersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginGroupMembersStaxUnmarshaller();
        }
        return instance;
    }
}

