/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;

class MapDataBinder
extends WebDataBinder {
    private final Class<?> type;
    private final ConversionService conversionService;

    public MapDataBinder(Class<?> type, ConversionService conversionService) {
        super(new HashMap());
        this.type = type;
        this.conversionService = conversionService;
    }

    @Override
    public Map<String, Object> getTarget() {
        return (Map)super.getTarget();
    }

    @Override
    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return new MapPropertyAccessor(this.type, (Map<String, Object>)this.getTarget(), this.conversionService);
    }

    private static class MapPropertyAccessor
    extends AbstractPropertyAccessor {
        private static final SpelExpressionParser PARSER = new SpelExpressionParser(new SpelParserConfiguration(false, true));
        @NonNull
        private final Class<?> type;
        @NonNull
        private final Map<String, Object> map;
        @NonNull
        private final ConversionService conversionService;

        @Override
        public boolean isReadableProperty(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWritableProperty(String propertyName) {
            try {
                return this.getPropertyPath(propertyName) != null;
            }
            catch (PropertyReferenceException o_O) {
                return false;
            }
        }

        @Override
        public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPropertyValue(String propertyName) throws BeansException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPropertyValue(String propertyName, Object value) throws BeansException {
            if (!this.isWritableProperty(propertyName)) {
                throw new NotWritablePropertyException(this.type, propertyName);
            }
            PropertyPath leafProperty = this.getPropertyPath(propertyName).getLeafProperty();
            TypeInformation<?> owningType = leafProperty.getOwningType();
            TypeInformation<?> propertyType = owningType.getProperty(leafProperty.getSegment());
            TypeInformation<?> typeInformation = propertyType = propertyName.endsWith("]") ? propertyType.getActualType() : propertyType;
            if (this.conversionRequired(value, propertyType.getType())) {
                PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(owningType.getType(), leafProperty.getSegment());
                MethodParameter methodParameter = new MethodParameter(descriptor.getReadMethod(), -1);
                TypeDescriptor typeDescriptor = TypeDescriptor.nested(methodParameter, 0);
                value = this.conversionService.convert(value, TypeDescriptor.forObject(value), typeDescriptor);
            }
            SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors(new PropertyTraversingMapAccessor(this.type, this.conversionService)).withConversionService(this.conversionService).withRootObject(this.map).build();
            Expression expression = PARSER.parseExpression(propertyName);
            try {
                expression.setValue(context, value);
            }
            catch (SpelEvaluationException o_O) {
                throw new NotWritablePropertyException(this.type, propertyName, "Could not write property!", o_O);
            }
        }

        private boolean conversionRequired(Object source, Class<?> targetType) {
            if (source == null || targetType.isInstance(source)) {
                return false;
            }
            return this.conversionService.canConvert(source.getClass(), targetType);
        }

        private PropertyPath getPropertyPath(String propertyName) {
            String plainPropertyPath = propertyName.replaceAll("\\[.*?\\]", "");
            return PropertyPath.from(plainPropertyPath, this.type);
        }

        @Generated
        public MapPropertyAccessor(@NonNull Class<?> type, @NonNull Map<String, Object> map, @NonNull ConversionService conversionService) {
            if (type == null) {
                throw new IllegalArgumentException("type is marked @NonNull but is null");
            }
            if (map == null) {
                throw new IllegalArgumentException("map is marked @NonNull but is null");
            }
            if (conversionService == null) {
                throw new IllegalArgumentException("conversionService is marked @NonNull but is null");
            }
            this.type = type;
            this.map = map;
            this.conversionService = conversionService;
        }

        private static final class PropertyTraversingMapAccessor
        extends MapAccessor {
            private final ConversionService conversionService;
            private Class<?> type;

            public PropertyTraversingMapAccessor(Class<?> type, ConversionService conversionService) {
                Assert.notNull(type, "Type must not be null!");
                Assert.notNull(conversionService, "ConversionService must not be null!");
                this.type = type;
                this.conversionService = conversionService;
            }

            @Override
            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                PropertyPath path = PropertyPath.from(name, this.type);
                try {
                    TypedValue typedValue = super.read(context, target, name);
                    return typedValue;
                }
                catch (AccessException o_O) {
                    Object emptyResult = path.isCollection() ? CollectionFactory.createCollection(List.class, 0) : CollectionFactory.createMap(Map.class, 0);
                    ((Map)target).put(name, emptyResult);
                    TypedValue typedValue = new TypedValue(emptyResult, this.getDescriptor(path, emptyResult));
                    return typedValue;
                }
                finally {
                    this.type = path.getType();
                }
            }

            private TypeDescriptor getDescriptor(PropertyPath path, Object emptyValue) {
                Class<?> actualPropertyType = path.getType();
                TypeDescriptor valueDescriptor = this.conversionService.canConvert(String.class, actualPropertyType) ? TypeDescriptor.valueOf(String.class) : TypeDescriptor.valueOf(HashMap.class);
                return path.isCollection() ? TypeDescriptor.collection(emptyValue.getClass(), valueDescriptor) : TypeDescriptor.map(emptyValue.getClass(), TypeDescriptor.valueOf(String.class), valueDescriptor);
            }
        }
    }
}

