/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.mill.util.SystemPropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverSupport {
    private static Logger log = LoggerFactory.getLogger(DriverSupport.class);
    private Options options;

    public DriverSupport(Options options) {
        this.options = options;
    }

    public void die() {
        this.usage();
        System.exit(1);
    }

    public void usage() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(80);
        help.printHelp(this.getClass().getCanonicalName(), this.options);
    }

    public CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println(e);
            this.die();
        }
        return cmd;
    }

    public final void execute(String[] args) {
        try {
            CommandLine cmd = this.parseArgs(args);
            if (cmd.hasOption("H")) {
                this.die();
            }
            this.processConfigFileOption(cmd);
            this.executeImpl(cmd);
        }
        catch (Throwable ex) {
            log.error("failed to startup " + this.getClass().getCanonicalName() + ": " + ex.getMessage(), ex);
        }
    }

    protected void processConfigFileOption(CommandLine cmd) {
        String workdir;
        String configPath = cmd.getOptionValue("c");
        if (configPath != null && new File(configPath).exists()) {
            try {
                SystemPropertyLoader.load(configPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (cmd.hasOption("w") && !StringUtils.isBlank(workdir = cmd.getOptionValue("w"))) {
            System.setProperty("workdir", workdir);
        }
    }

    protected abstract void executeImpl(CommandLine var1);

    protected void setSystemProperty(String name, String value) {
        this.setSystemProperty(name, value, null);
    }

    protected void setSystemProperty(String name, String value, String defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        System.setProperty(name, value);
    }
}

