/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.data.jpa.provider.HibernateJpaParametersParameterAccessor;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public enum PersistenceProvider implements QueryExtractor,
ProxyIdAccessor
{
    HIBERNATE(Collections.singletonList("org.hibernate.jpa.HibernateEntityManager"), Collections.singletonList("org.hibernate.metamodel.internal.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query2) {
            return HibernateUtils.getHibernateQuery(query2);
        }

        @Override
        public String getCountQueryPlaceholder() {
            return "*";
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof HibernateProxy;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }

        @Override
        public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
            return type.hasSingleIdAttribute() ? Collections.emptySet() : super.getIdClassAttributes(type);
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new HibernateScrollableResultsIterator(jpaQuery);
        }

        @Override
        public JpaParametersParameterAccessor getParameterAccessor(JpaParameters parameters, Object[] values, EntityManager em) {
            return new HibernateJpaParametersParameterAccessor(parameters, values, em);
        }
    }
    ,
    ECLIPSELINK(Collections.singleton("org.eclipse.persistence.jpa.JpaEntityManager"), Collections.singleton("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query2) {
            return ((JpaQuery)query2).getDatabaseQuery().getJPQLString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        @Nullable
        public Object getIdentifierFrom(Object entity) {
            return null;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
        }
    }
    ,
    GENERIC_JPA(Collections.singleton("javax.persistence.EntityManager"), Collections.emptySet()){

        @Override
        @Nullable
        public String extractQueryString(Query query2) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        @Nullable
        public Object getIdentifierFrom(Object entity) {
            return null;
        }
    };

    static ConcurrentReferenceHashMap<Class<?>, PersistenceProvider> CACHE;
    private final Iterable<String> entityManagerClassNames;
    private final Iterable<String> metamodelClassNames;

    private PersistenceProvider(Iterable<String> entityManagerClassNames, Iterable<String> metamodelClassNames) {
        this.entityManagerClassNames = entityManagerClassNames;
        this.metamodelClassNames = metamodelClassNames;
    }

    private static PersistenceProvider cacheAndReturn(Class<?> type, PersistenceProvider provider) {
        CACHE.put(type, provider);
        return provider;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em, "EntityManager must not be null!");
        Class<?> entityManagerType = em.getDelegate().getClass();
        PersistenceProvider cachedProvider = CACHE.get(entityManagerType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return PersistenceProvider.cacheAndReturn(entityManagerType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(entityManagerType, GENERIC_JPA);
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, "Metamodel must not be null!");
        Class<?> metamodelType = metamodel.getClass();
        PersistenceProvider cachedProvider = CACHE.get(metamodelType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return PersistenceProvider.cacheAndReturn(metamodelType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(metamodelType, GENERIC_JPA);
    }

    public JpaParametersParameterAccessor getParameterAccessor(JpaParameters parameters, Object[] values, EntityManager em) {
        return new JpaParametersParameterAccessor(parameters, values);
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
        try {
            return type.getIdClassAttributes();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptySet();
        }
    }

    public static Object condense(Object value) {
        ClassLoader classLoader = PersistenceProvider.class.getClassLoader();
        if (ClassUtils.isPresent("org.hibernate.jpa.TypedParameterValue", classLoader)) {
            try {
                Class<?> typeParameterValue = ClassUtils.forName("org.hibernate.jpa.TypedParameterValue", classLoader);
                if (typeParameterValue.isInstance(value)) {
                    return null;
                }
            }
            catch (ClassNotFoundException | LinkageError o_O) {
                return value;
            }
        }
        return value;
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    static {
        CACHE = new ConcurrentReferenceHashMap();
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        @Nullable
        private final ScrollableCursor scrollableCursor;

        EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        @Override
        public boolean hasNext() {
            return this.scrollableCursor != null && this.scrollableCursor.hasNext();
        }

        @Override
        public T next() {
            if (this.scrollableCursor == null) {
                throw new NoSuchElementException("No ScrollableCursor");
            }
            return (T)this.scrollableCursor.next();
        }

        @Override
        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator
    implements CloseableIterator<Object> {
        @Nullable
        private final ScrollableResults scrollableResults;

        HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.query.Query query2 = jpaQuery.unwrap(org.hibernate.query.Query.class);
            this.scrollableResults = query2.setReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).scroll(ScrollMode.FORWARD_ONLY);
        }

        @Override
        public Object next() {
            if (this.scrollableResults == null) {
                throw new NoSuchElementException("No ScrollableResults");
            }
            Object[] row = this.scrollableResults.get();
            return row.length == 1 ? row[0] : row;
        }

        @Override
        public boolean hasNext() {
            return this.scrollableResults != null && this.scrollableResults.next();
        }

        @Override
        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "javax.persistence.EntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.jpa.HibernateEntityManager";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.metamodel.internal.MetamodelImpl";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
    }
}

