/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.PublicKeyConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PublicKeyConfigStaxUnmarshaller
implements Unmarshaller<PublicKeyConfig, StaxUnmarshallerContext> {
    private static PublicKeyConfigStaxUnmarshaller instance;

    @Override
    public PublicKeyConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublicKeyConfig publicKeyConfig = new PublicKeyConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publicKeyConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CallerReference", targetDepth)) {
                    publicKeyConfig.setCallerReference(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name", targetDepth)) {
                    publicKeyConfig.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EncodedKey", targetDepth)) {
                    publicKeyConfig.setEncodedKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Comment", targetDepth)) continue;
                publicKeyConfig.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publicKeyConfig;
    }

    public static PublicKeyConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyConfigStaxUnmarshaller();
        }
        return instance;
    }
}

