/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.util.ArrayList;
import org.duracloud.snapshot.dto.task.CompleteRestoreTaskParameters;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskResult;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteRestoreTaskRunner
implements TaskRunner {
    private Logger log = LoggerFactory.getLogger(CompleteRestoreTaskRunner.class);
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private AmazonS3 s3Client;

    public CompleteRestoreTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, AmazonS3 s3Client) {
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.s3Client = s3Client;
    }

    @Override
    public String getName() {
        return "complete-restore";
    }

    @Override
    public String performTask(String taskParameters) {
        CompleteRestoreTaskParameters taskParams = CompleteRestoreTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        int daysToExpire = taskParams.getDaysToExpire();
        String bucketName = this.unwrappedSnapshotProvider.getBucketName(spaceId);
        this.log.info("Performing Complete Restore Task for spaceID: " + spaceId + ". Restored content will expire in " + daysToExpire + " days");
        BucketLifecycleConfiguration.Rule expireRule = new BucketLifecycleConfiguration.Rule().withId("clear-content-rule").withExpirationInDays(daysToExpire).withStatus("Enabled".toString());
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        rules.add(expireRule);
        BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration().withRules(rules);
        this.s3Client.setBucketLifecycleConfiguration(bucketName, configuration);
        this.log.info("Complete Restore Task for space " + spaceId + " completed successfully");
        String result = "Complete restore was successful";
        return new CompleteSnapshotTaskResult(result).serialize();
    }
}

