/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

final class CompositeLog
implements Log {
    private static final Log NO_OP_LOG = new NoOpLog();
    private final List<Log> loggers;

    CompositeLog(List<Log> loggers) {
        this.loggers = loggers;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Log::isFatalEnabled);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Log::isErrorEnabled);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Log::isWarnEnabled);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Log::isInfoEnabled);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Log::isDebugEnabled);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Log::isTraceEnabled);
    }

    private boolean isEnabled(Predicate<Log> predicate) {
        return this.getLogger(predicate) != NO_OP_LOG;
    }

    @Override
    public void fatal(Object message) {
        this.getLogger(Log::isFatalEnabled).fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable ex) {
        this.getLogger(Log::isFatalEnabled).fatal(message, ex);
    }

    @Override
    public void error(Object message) {
        this.getLogger(Log::isErrorEnabled).error(message);
    }

    @Override
    public void error(Object message, Throwable ex) {
        this.getLogger(Log::isErrorEnabled).error(message, ex);
    }

    @Override
    public void warn(Object message) {
        this.getLogger(Log::isWarnEnabled).warn(message);
    }

    @Override
    public void warn(Object message, Throwable ex) {
        this.getLogger(Log::isWarnEnabled).warn(message, ex);
    }

    @Override
    public void info(Object message) {
        this.getLogger(Log::isInfoEnabled).info(message);
    }

    @Override
    public void info(Object message, Throwable ex) {
        this.getLogger(Log::isInfoEnabled).info(message, ex);
    }

    @Override
    public void debug(Object message) {
        this.getLogger(Log::isDebugEnabled).debug(message);
    }

    @Override
    public void debug(Object message, Throwable ex) {
        this.getLogger(Log::isDebugEnabled).debug(message, ex);
    }

    @Override
    public void trace(Object message) {
        this.getLogger(Log::isTraceEnabled).trace(message);
    }

    @Override
    public void trace(Object message, Throwable ex) {
        this.getLogger(Log::isTraceEnabled).trace(message, ex);
    }

    private Log getLogger(Predicate<Log> predicate) {
        for (Log logger2 : this.loggers) {
            if (!predicate.test(logger2)) continue;
            return logger2;
        }
        return NO_OP_LOG;
    }
}

